/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.employee;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.skill.Skill;

@Entity
@NamedQueries(value={@NamedQuery(name="Employee.findAll", query="select e from Employee e where e.tenantId = :tenantId order by LOWER(e.name)"), @NamedQuery(name="Employee.deleteForTenant", query="delete from Employee e where e.tenantId = :tenantId")})
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "name"})})
public class Employee
extends AbstractPersistable {
    @NotNull
    @Size(min=1, max=120)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private String name;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="EmployeeSkillProficiencySet", joinColumns={@JoinColumn(name="employeeId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> skillProficiencySet;

    public Employee() {
    }

    public Employee(Integer tenantId, String name) {
        super(tenantId);
        this.name = name;
        this.skillProficiencySet = new HashSet<Skill>(2);
    }

    public boolean hasSkill(Skill skill) {
        return this.skillProficiencySet.contains(skill);
    }

    public boolean hasSkills(Collection<Skill> skills) {
        return this.skillProficiencySet.containsAll(skills);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Skill> getSkillProficiencySet() {
        return this.skillProficiencySet;
    }

    public void setSkillProficiencySet(Set<Skill> skillProficiencySet) {
        this.skillProficiencySet = skillProficiencySet;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Employee) {
            Employee other = (Employee)o;
            return this.name.equals(other.getName()) && this.skillProficiencySet.equals(other.getSkillProficiencySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.name.hashCode() ^ this.skillProficiencySet.hashCode();
    }
}

