/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.employee;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.client.ObjectWriter;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.util.List;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.employee.view.EmployeeAvailabilityView;

public final class EmployeeRestServiceBuilder {
    private static ObjectReader1 objectreader1;
    private static ObjectReader2 objectreader2;
    private static ObjectMapper1 objectmapper1;
    private static ObjectMapper2 objectmapper2;

    private EmployeeRestServiceBuilder() {
    }

    private static ObjectReader1 getObjectReader1() {
        if (objectreader1 == null) {
            objectreader1 = (ObjectReader1)GWT.create(ObjectReader1.class);
        }
        return objectreader1;
    }

    private static ObjectReader2 getObjectReader2() {
        if (objectreader2 == null) {
            objectreader2 = (ObjectReader2)GWT.create(ObjectReader2.class);
        }
        return objectreader2;
    }

    private static ObjectMapper1 getObjectMapper1() {
        if (objectmapper1 == null) {
            objectmapper1 = (ObjectMapper1)GWT.create(ObjectMapper1.class);
        }
        return objectmapper1;
    }

    private static ObjectMapper2 getObjectMapper2() {
        if (objectmapper2 == null) {
            objectmapper2 = (ObjectMapper2)GWT.create(ObjectMapper2.class);
        }
        return objectmapper2;
    }

    public static final RestRequestBuilder<Void, List<Employee>> getEmployeeList(Integer tenantId) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/employee/").addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)EmployeeRestServiceBuilder.getObjectReader1());
    }

    public static final Request getEmployeeList(Integer tenantId, RestCallback<List<Employee>> _callback_) {
        return EmployeeRestServiceBuilder.getEmployeeList(tenantId).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Employee> getEmployee(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/employee/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)EmployeeRestServiceBuilder.getObjectMapper1());
    }

    public static final Request getEmployee(Integer tenantId, Long id, RestCallback<Employee> _callback_) {
        return EmployeeRestServiceBuilder.getEmployee(tenantId, id).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Employee, Employee> addEmployee(Integer tenantId, Employee employee) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/employee/add").body((Object)employee).bodyConverter((ObjectWriter)EmployeeRestServiceBuilder.getObjectMapper1()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)EmployeeRestServiceBuilder.getObjectMapper1());
    }

    public static final Request addEmployee(Integer tenantId, Employee employee, RestCallback<Employee> _callback_) {
        return EmployeeRestServiceBuilder.addEmployee(tenantId, employee).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Employee, Employee> updateEmployee(Integer tenantId, Employee employee) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/employee/update").body((Object)employee).bodyConverter((ObjectWriter)EmployeeRestServiceBuilder.getObjectMapper1()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)EmployeeRestServiceBuilder.getObjectMapper1());
    }

    public static final Request updateEmployee(Integer tenantId, Employee employee, RestCallback<Employee> _callback_) {
        return EmployeeRestServiceBuilder.updateEmployee(tenantId, employee).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Boolean> removeEmployee(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.DELETE).url("/tenant/{tenantId}/employee/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)EmployeeRestServiceBuilder.getObjectReader2());
    }

    public static final Request removeEmployee(Integer tenantId, Long id, RestCallback<Boolean> _callback_) {
        return EmployeeRestServiceBuilder.removeEmployee(tenantId, id).callback(_callback_).send();
    }

    public static final RestRequestBuilder<EmployeeAvailabilityView, EmployeeAvailabilityView> addEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailability) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/employee/availability/add").body((Object)employeeAvailability).bodyConverter((ObjectWriter)EmployeeRestServiceBuilder.getObjectMapper2()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)EmployeeRestServiceBuilder.getObjectMapper2());
    }

    public static final Request addEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailability, RestCallback<EmployeeAvailabilityView> _callback_) {
        return EmployeeRestServiceBuilder.addEmployeeAvailability(tenantId, employeeAvailability).callback(_callback_).send();
    }

    public static final RestRequestBuilder<EmployeeAvailabilityView, EmployeeAvailabilityView> updateEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailability) {
        return new RestRequestBuilder().method(RequestBuilder.PUT).url("/tenant/{tenantId}/employee/availability/update").body((Object)employeeAvailability).bodyConverter((ObjectWriter)EmployeeRestServiceBuilder.getObjectMapper2()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)EmployeeRestServiceBuilder.getObjectMapper2());
    }

    public static final Request updateEmployeeAvailability(Integer tenantId, EmployeeAvailabilityView employeeAvailability, RestCallback<EmployeeAvailabilityView> _callback_) {
        return EmployeeRestServiceBuilder.updateEmployeeAvailability(tenantId, employeeAvailability).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Boolean> removeEmployeeAvailability(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.DELETE).url("/tenant/{tenantId}/employee/availability/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)EmployeeRestServiceBuilder.getObjectReader2());
    }

    public static final Request removeEmployeeAvailability(Integer tenantId, Long id, RestCallback<Boolean> _callback_) {
        return EmployeeRestServiceBuilder.removeEmployeeAvailability(tenantId, id).callback(_callback_).send();
    }

    static interface ObjectMapper2
    extends ObjectMapper<EmployeeAvailabilityView> {
    }

    static interface ObjectMapper1
    extends ObjectMapper<Employee> {
    }

    static interface ObjectReader2
    extends ObjectReader<Boolean> {
    }

    static interface ObjectReader1
    extends ObjectReader<List<Employee>> {
    }
}

