/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.roster;

import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.client.ObjectWriter;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.util.List;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.roster.PublishResult;
import org.optaweb.employeerostering.shared.roster.RosterState;
import org.optaweb.employeerostering.shared.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.shared.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.shared.spot.Spot;

public final class RosterRestServiceBuilder {
    private static ObjectReader1 objectreader1;
    private static ObjectReader2 objectreader2;
    private static ObjectReader3 objectreader3;
    private static ObjectReader4 objectreader4;
    private static ObjectWriter1 objectwriter1;
    private static ObjectWriter2 objectwriter2;

    private RosterRestServiceBuilder() {
    }

    private static ObjectReader1 getObjectReader1() {
        if (objectreader1 == null) {
            objectreader1 = (ObjectReader1)GWT.create(ObjectReader1.class);
        }
        return objectreader1;
    }

    private static ObjectReader2 getObjectReader2() {
        if (objectreader2 == null) {
            objectreader2 = (ObjectReader2)GWT.create(ObjectReader2.class);
        }
        return objectreader2;
    }

    private static ObjectReader3 getObjectReader3() {
        if (objectreader3 == null) {
            objectreader3 = (ObjectReader3)GWT.create(ObjectReader3.class);
        }
        return objectreader3;
    }

    private static ObjectReader4 getObjectReader4() {
        if (objectreader4 == null) {
            objectreader4 = (ObjectReader4)GWT.create(ObjectReader4.class);
        }
        return objectreader4;
    }

    private static ObjectWriter1 getObjectWriter1() {
        if (objectwriter1 == null) {
            objectwriter1 = (ObjectWriter1)GWT.create(ObjectWriter1.class);
        }
        return objectwriter1;
    }

    private static ObjectWriter2 getObjectWriter2() {
        if (objectwriter2 == null) {
            objectwriter2 = (ObjectWriter2)GWT.create(ObjectWriter2.class);
        }
        return objectwriter2;
    }

    public static final RestRequestBuilder<Void, RosterState> getRosterState(Integer tenantId) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/roster/state").addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)RosterRestServiceBuilder.getObjectReader1());
    }

    public static final Request getRosterState(Integer tenantId, RestCallback<RosterState> _callback_) {
        return RosterRestServiceBuilder.getRosterState(tenantId).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, ShiftRosterView> getCurrentShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/roster/shiftRosterView/current").addPathParam("tenantId", (Object)tenantId).addQueryParam("p", (Object)pageNumber).addQueryParam("n", (Object)numberOfItemsPerPage).responseConverter((ObjectReader)RosterRestServiceBuilder.getObjectReader2());
    }

    public static final Request getCurrentShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, RestCallback<ShiftRosterView> _callback_) {
        return RosterRestServiceBuilder.getCurrentShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, ShiftRosterView> getShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/roster/shiftRosterView").addPathParam("tenantId", (Object)tenantId).addQueryParam("p", (Object)pageNumber).addQueryParam("n", (Object)numberOfItemsPerPage).addQueryParam("startDate", (Object)startDateString).addQueryParam("endDate", (Object)endDateString).responseConverter((ObjectReader)RosterRestServiceBuilder.getObjectReader2());
    }

    public static final Request getShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString, RestCallback<ShiftRosterView> _callback_) {
        return RosterRestServiceBuilder.getShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString).callback(_callback_).send();
    }

    public static final RestRequestBuilder<List<Spot>, ShiftRosterView> getShiftRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Spot> spots) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/roster/shiftRosterView/for").body(spots).bodyConverter((ObjectWriter)RosterRestServiceBuilder.getObjectWriter1()).addPathParam("tenantId", (Object)tenantId).addQueryParam("startDate", (Object)startDateString).addQueryParam("endDate", (Object)endDateString).responseConverter((ObjectReader)RosterRestServiceBuilder.getObjectReader2());
    }

    public static final Request getShiftRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Spot> spots, RestCallback<ShiftRosterView> _callback_) {
        return RosterRestServiceBuilder.getShiftRosterViewFor(tenantId, startDateString, endDateString, spots).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, AvailabilityRosterView> getCurrentAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/roster/availabilityRosterView/current").addPathParam("tenantId", (Object)tenantId).addQueryParam("p", (Object)pageNumber).addQueryParam("n", (Object)numberOfItemsPerPage).responseConverter((ObjectReader)RosterRestServiceBuilder.getObjectReader3());
    }

    public static final Request getCurrentAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, RestCallback<AvailabilityRosterView> _callback_) {
        return RosterRestServiceBuilder.getCurrentAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, AvailabilityRosterView> getAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/roster/availabilityRosterView").addPathParam("tenantId", (Object)tenantId).addQueryParam("p", (Object)pageNumber).addQueryParam("n", (Object)numberOfItemsPerPage).addQueryParam("startDate", (Object)startDateString).addQueryParam("endDate", (Object)endDateString).responseConverter((ObjectReader)RosterRestServiceBuilder.getObjectReader3());
    }

    public static final Request getAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString, RestCallback<AvailabilityRosterView> _callback_) {
        return RosterRestServiceBuilder.getAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString).callback(_callback_).send();
    }

    public static final RestRequestBuilder<List<Employee>, AvailabilityRosterView> getAvailabilityRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Employee> employees) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/roster/availabilityRosterView/for").body(employees).bodyConverter((ObjectWriter)RosterRestServiceBuilder.getObjectWriter2()).addPathParam("tenantId", (Object)tenantId).addQueryParam("startDate", (Object)startDateString).addQueryParam("endDate", (Object)endDateString).responseConverter((ObjectReader)RosterRestServiceBuilder.getObjectReader3());
    }

    public static final Request getAvailabilityRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Employee> employees, RestCallback<AvailabilityRosterView> _callback_) {
        return RosterRestServiceBuilder.getAvailabilityRosterViewFor(tenantId, startDateString, endDateString, employees).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Void> solveRoster(Integer tenantId) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/roster/solve").addPathParam("tenantId", (Object)tenantId);
    }

    public static final Request solveRoster(Integer tenantId, RestCallback<Void> _callback_) {
        return RosterRestServiceBuilder.solveRoster(tenantId).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Void> terminateRosterEarly(Integer tenantId) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/roster/terminate").addPathParam("tenantId", (Object)tenantId);
    }

    public static final Request terminateRosterEarly(Integer tenantId, RestCallback<Void> _callback_) {
        return RosterRestServiceBuilder.terminateRosterEarly(tenantId).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, PublishResult> publishAndProvision(Integer tenantId) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/roster/publishAndProvision").addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)RosterRestServiceBuilder.getObjectReader4());
    }

    public static final Request publishAndProvision(Integer tenantId, RestCallback<PublishResult> _callback_) {
        return RosterRestServiceBuilder.publishAndProvision(tenantId).callback(_callback_).send();
    }

    static interface ObjectWriter2
    extends ObjectWriter<List<Employee>> {
    }

    static interface ObjectWriter1
    extends ObjectWriter<List<Spot>> {
    }

    static interface ObjectReader4
    extends ObjectReader<PublishResult> {
    }

    static interface ObjectReader3
    extends ObjectReader<AvailabilityRosterView> {
    }

    static interface ObjectReader2
    extends ObjectReader<ShiftRosterView> {
    }

    static interface ObjectReader1
    extends ObjectReader<RosterState> {
    }
}

