/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.skill;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.client.ObjectWriter;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.util.List;
import org.optaweb.employeerostering.shared.skill.Skill;

public final class SkillRestServiceBuilder {
    private static ObjectReader1 objectreader1;
    private static ObjectReader2 objectreader2;
    private static ObjectMapper1 objectmapper1;

    private SkillRestServiceBuilder() {
    }

    private static ObjectReader1 getObjectReader1() {
        if (objectreader1 == null) {
            objectreader1 = (ObjectReader1)GWT.create(ObjectReader1.class);
        }
        return objectreader1;
    }

    private static ObjectReader2 getObjectReader2() {
        if (objectreader2 == null) {
            objectreader2 = (ObjectReader2)GWT.create(ObjectReader2.class);
        }
        return objectreader2;
    }

    private static ObjectMapper1 getObjectMapper1() {
        if (objectmapper1 == null) {
            objectmapper1 = (ObjectMapper1)GWT.create(ObjectMapper1.class);
        }
        return objectmapper1;
    }

    public static final RestRequestBuilder<Void, List<Skill>> getSkillList(Integer tenantId) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/skill/").addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)SkillRestServiceBuilder.getObjectReader1());
    }

    public static final Request getSkillList(Integer tenantId, RestCallback<List<Skill>> _callback_) {
        return SkillRestServiceBuilder.getSkillList(tenantId).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Skill> getSkill(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/skill/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)SkillRestServiceBuilder.getObjectMapper1());
    }

    public static final Request getSkill(Integer tenantId, Long id, RestCallback<Skill> _callback_) {
        return SkillRestServiceBuilder.getSkill(tenantId, id).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Skill, Skill> addSkill(Integer tenantId, Skill skill) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/skill/add").body((Object)skill).bodyConverter((ObjectWriter)SkillRestServiceBuilder.getObjectMapper1()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)SkillRestServiceBuilder.getObjectMapper1());
    }

    public static final Request addSkill(Integer tenantId, Skill skill, RestCallback<Skill> _callback_) {
        return SkillRestServiceBuilder.addSkill(tenantId, skill).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Skill, Skill> updateSkill(Integer tenantId, Skill skill) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/skill/update").body((Object)skill).bodyConverter((ObjectWriter)SkillRestServiceBuilder.getObjectMapper1()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)SkillRestServiceBuilder.getObjectMapper1());
    }

    public static final Request updateSkill(Integer tenantId, Skill skill, RestCallback<Skill> _callback_) {
        return SkillRestServiceBuilder.updateSkill(tenantId, skill).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Boolean> removeSkill(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.DELETE).url("/tenant/{tenantId}/skill/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)SkillRestServiceBuilder.getObjectReader2());
    }

    public static final Request removeSkill(Integer tenantId, Long id, RestCallback<Boolean> _callback_) {
        return SkillRestServiceBuilder.removeSkill(tenantId, id).callback(_callback_).send();
    }

    static interface ObjectMapper1
    extends ObjectMapper<Skill> {
    }

    static interface ObjectReader2
    extends ObjectReader<Boolean> {
    }

    static interface ObjectReader1
    extends ObjectReader<List<Skill>> {
    }
}

