/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.spot;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.skill.Skill;

@Entity
@NamedQueries(value={@NamedQuery(name="Spot.findAll", query="select s from Spot s where s.tenantId = :tenantId order by LOWER(s.name)"), @NamedQuery(name="Spot.deleteForTenant", query="delete from Spot s where s.tenantId = :tenantId")})
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "name"}), @UniqueConstraint(columnNames={"id"})})
public class Spot
extends AbstractPersistable {
    @NotNull
    @Size(min=1, max=120)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private String name;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="SpotRequiredSkillSet", joinColumns={@JoinColumn(name="spotId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> requiredSkillSet;

    public Spot() {
    }

    public Spot(Integer tenantId, String name, Set<Skill> requiredSkillSet) {
        super(tenantId);
        this.name = name;
        this.requiredSkillSet = requiredSkillSet;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Skill> getRequiredSkillSet() {
        return this.requiredSkillSet;
    }

    public void setRequiredSkillSet(Set<Skill> requiredSkillSet) {
        this.requiredSkillSet = requiredSkillSet;
    }
}

