/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.spot;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.client.ObjectWriter;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.util.List;
import org.optaweb.employeerostering.shared.spot.Spot;

public final class SpotRestServiceBuilder {
    private static ObjectReader1 objectreader1;
    private static ObjectReader2 objectreader2;
    private static ObjectMapper1 objectmapper1;

    private SpotRestServiceBuilder() {
    }

    private static ObjectReader1 getObjectReader1() {
        if (objectreader1 == null) {
            objectreader1 = (ObjectReader1)GWT.create(ObjectReader1.class);
        }
        return objectreader1;
    }

    private static ObjectReader2 getObjectReader2() {
        if (objectreader2 == null) {
            objectreader2 = (ObjectReader2)GWT.create(ObjectReader2.class);
        }
        return objectreader2;
    }

    private static ObjectMapper1 getObjectMapper1() {
        if (objectmapper1 == null) {
            objectmapper1 = (ObjectMapper1)GWT.create(ObjectMapper1.class);
        }
        return objectmapper1;
    }

    public static final RestRequestBuilder<Void, List<Spot>> getSpotList(Integer tenantId) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/spot/").addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)SpotRestServiceBuilder.getObjectReader1());
    }

    public static final Request getSpotList(Integer tenantId, RestCallback<List<Spot>> _callback_) {
        return SpotRestServiceBuilder.getSpotList(tenantId).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Spot> getSpot(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/spot/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)SpotRestServiceBuilder.getObjectMapper1());
    }

    public static final Request getSpot(Integer tenantId, Long id, RestCallback<Spot> _callback_) {
        return SpotRestServiceBuilder.getSpot(tenantId, id).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Spot, Spot> addSpot(Integer tenantId, Spot spot) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/spot/add").body((Object)spot).bodyConverter((ObjectWriter)SpotRestServiceBuilder.getObjectMapper1()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)SpotRestServiceBuilder.getObjectMapper1());
    }

    public static final Request addSpot(Integer tenantId, Spot spot, RestCallback<Spot> _callback_) {
        return SpotRestServiceBuilder.addSpot(tenantId, spot).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Spot, Spot> updateSpot(Integer tenantId, Spot spot) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/spot/update").body((Object)spot).bodyConverter((ObjectWriter)SpotRestServiceBuilder.getObjectMapper1()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)SpotRestServiceBuilder.getObjectMapper1());
    }

    public static final Request updateSpot(Integer tenantId, Spot spot, RestCallback<Spot> _callback_) {
        return SpotRestServiceBuilder.updateSpot(tenantId, spot).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Boolean> removeSpot(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.DELETE).url("/tenant/{tenantId}/spot/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)SpotRestServiceBuilder.getObjectReader2());
    }

    public static final Request removeSpot(Integer tenantId, Long id, RestCallback<Boolean> _callback_) {
        return SpotRestServiceBuilder.removeSpot(tenantId, id).callback(_callback_).send();
    }

    static interface ObjectMapper1
    extends ObjectMapper<Spot> {
    }

    static interface ObjectReader2
    extends ObjectReader<Boolean> {
    }

    static interface ObjectReader1
    extends ObjectReader<List<Spot>> {
    }
}

