/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.rotation;

import java.time.LocalTime;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.optaweb.employeerostering.shared.contract.Contract;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.rotation.ShiftTemplate;
import org.optaweb.employeerostering.shared.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.shared.spot.Spot;

public class ShiftTemplateTest {
    private static final int ROTATION_LENGTH = 7;

    @Test
    public void testConversionFromToView() {
        Contract contract = new Contract(Integer.valueOf(1), "Contract");
        Spot testSpot = new Spot(Integer.valueOf(1), "Test", Collections.emptySet());
        Employee testEmployee = new Employee(Integer.valueOf(1), "Employee", contract, Collections.emptySet());
        this.testConversion(new ShiftTemplate(Integer.valueOf(1), testSpot, 0, LocalTime.of(9, 0), 2, LocalTime.of(17, 0)), 7);
        this.testConversion(new ShiftTemplate(Integer.valueOf(1), testSpot, 0, LocalTime.of(9, 0), 2, LocalTime.of(17, 0), testEmployee), 7);
        this.testConversion(new ShiftTemplate(Integer.valueOf(1), testSpot, 2, LocalTime.of(11, 0), 4, LocalTime.of(14, 0)), 7);
        this.testConversion(new ShiftTemplate(Integer.valueOf(1), testSpot, 6, LocalTime.of(19, 0), 0, LocalTime.of(6, 0)), 7);
    }

    public void testConversion(ShiftTemplate template, int rotationLength) {
        ShiftTemplateView view = new ShiftTemplateView(Integer.valueOf(rotationLength), template);
        ShiftTemplate templateFromView = new ShiftTemplate(Integer.valueOf(rotationLength), view, template.getSpot(), template.getRotationEmployee());
        Assert.assertEquals((Object)template.getStartDayOffset(), (Object)templateFromView.getStartDayOffset());
        Assert.assertEquals((Object)template.getEndDayOffset(), (Object)templateFromView.getEndDayOffset());
        Assert.assertEquals((Object)template.getStartTime(), (Object)templateFromView.getStartTime());
        Assert.assertEquals((Object)template.getEndTime(), (Object)templateFromView.getEndTime());
        Assert.assertEquals((Object)template.getSpot(), (Object)templateFromView.getSpot());
        Assert.assertEquals((Object)template.getRotationEmployee(), (Object)templateFromView.getRotationEmployee());
        Assert.assertEquals((Object)template.getTenantId(), (Object)templateFromView.getTenantId());
        Assert.assertEquals((Object)template.getId(), (Object)templateFromView.getId());
    }
}

