/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.common;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.IsoFields;

public class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static boolean doTimeslotsIntersect(OffsetDateTime start1, OffsetDateTime end1, OffsetDateTime start2, OffsetDateTime end2) {
        return !start1.isAfter(end2) && !end1.isBefore(start2);
    }

    public static boolean doTimeslotsIntersect(LocalDate date, OffsetTime start1, OffsetTime end1, OffsetDateTime start2, OffsetDateTime end2) {
        return DateTimeUtils.doTimeslotsIntersect(start1.atDate(date), end1.atDate(date), start2, end2);
    }

    public static boolean sameWeek(DayOfWeek weekStarting, OffsetDateTime dateTime1, OffsetDateTime dateTime2) {
        int dayDifference = weekStarting.getValue() - 1;
        OffsetDateTime first = dateTime1.minusDays(dayDifference);
        OffsetDateTime second = dateTime2.minusDays(dayDifference);
        return first.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR) == second.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR) && first.get(IsoFields.WEEK_BASED_YEAR) == second.get(IsoFields.WEEK_BASED_YEAR);
    }
}

