/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.contract;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;

@Entity
@NamedQueries(value={@NamedQuery(name="Contract.findAll", query="select c from Contract c where c.tenantId = :tenantId order by LOWER(c.name)"), @NamedQuery(name="Contract.deleteForTenant", query="delete from Contract c where c.tenantId = :tenantId")})
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "name"}), @UniqueConstraint(columnNames={"id"})})
public class Contract
extends AbstractPersistable {
    @NotNull
    @Size(min=1, max=120)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private String name;
    @Min(value=0L)
    @Max(value=1440L)
    private Integer maximumMinutesPerDay;
    @Min(value=0L)
    @Max(value=10080L)
    private Integer maximumMinutesPerWeek;
    @Min(value=0L)
    @Max(value=44640L)
    private Integer maximumMinutesPerMonth;
    @Min(value=0L)
    @Max(value=527040L)
    private Integer maximumMinutesPerYear;

    public Contract() {
    }

    public Contract(Integer tenantId, String name) {
        this(tenantId, name, null, null, null, null);
    }

    public Contract(Integer tenantId, String name, Integer maximumMinutesPerDay, Integer maximumMinutesPerWeek, Integer maximumMinutesPerMonth, Integer maximumMinutesPerYear) {
        super(tenantId);
        this.name = name;
        this.maximumMinutesPerDay = maximumMinutesPerDay;
        this.maximumMinutesPerWeek = maximumMinutesPerWeek;
        this.maximumMinutesPerMonth = maximumMinutesPerMonth;
        this.maximumMinutesPerYear = maximumMinutesPerYear;
    }

    @AssertTrue
    @JsonIgnore
    public boolean isValid() {
        if (this.maximumMinutesPerDay != null && this.maximumMinutesPerDay <= 0) {
            return false;
        }
        if (this.maximumMinutesPerWeek != null && this.maximumMinutesPerWeek <= 0) {
            return false;
        }
        if (this.maximumMinutesPerMonth != null && this.maximumMinutesPerMonth <= 0) {
            return false;
        }
        return this.maximumMinutesPerYear == null || this.maximumMinutesPerYear > 0;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMaximumMinutesPerDay() {
        return this.maximumMinutesPerDay;
    }

    public void setMaximumMinutesPerDay(Integer maximumMinutesPerDay) {
        this.maximumMinutesPerDay = maximumMinutesPerDay;
    }

    public Integer getMaximumMinutesPerWeek() {
        return this.maximumMinutesPerWeek;
    }

    public void setMaximumMinutesPerWeek(Integer maximumMinutesPerWeek) {
        this.maximumMinutesPerWeek = maximumMinutesPerWeek;
    }

    public Integer getMaximumMinutesPerMonth() {
        return this.maximumMinutesPerMonth;
    }

    public void setMaximumMinutesPerMonth(Integer maximumMinutesPerMonth) {
        this.maximumMinutesPerMonth = maximumMinutesPerMonth;
    }

    public Integer getMaximumMinutesPerYear() {
        return this.maximumMinutesPerYear;
    }

    public void setMaximumMinutesPerYear(Integer maximumMinutesPerYear) {
        this.maximumMinutesPerYear = maximumMinutesPerYear;
    }
}

