/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.contract;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.optaweb.employeerostering.shared.contract.Contract;

@Api(tags={"Contract"})
@Path(value="/tenant/{tenantId}/contract")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ContractRestService {
    @ApiOperation(value="Get a list of all contracts")
    @GET
    @Path(value="/")
    public List<Contract> getContractList(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1);

    @ApiOperation(value="Get a contract by id")
    @GET
    @Path(value="/{id}")
    public Contract getContract(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(required=true) @PathParam(value="id") Long var2);

    @ApiOperation(value="Add a new contract")
    @POST
    @Path(value="/add")
    public Contract addContract(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(value="with no id", required=true) Contract var2);

    @ApiOperation(value="Update a contract")
    @POST
    @Path(value="/update")
    public Contract updateContract(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(required=true) Contract var2);

    @ApiOperation(value="Delete a contract")
    @DELETE
    @Path(value="/{id}")
    public Boolean removeContract(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(required=true) @PathParam(value="id") Long var2);
}

