/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.contract;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.client.ObjectWriter;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.util.List;
import org.optaweb.employeerostering.shared.contract.Contract;

public final class ContractRestServiceBuilder {
    private static ObjectReader1 objectreader1;
    private static ObjectReader2 objectreader2;
    private static ObjectMapper1 objectmapper1;

    private ContractRestServiceBuilder() {
    }

    private static ObjectReader1 getObjectReader1() {
        if (objectreader1 == null) {
            objectreader1 = (ObjectReader1)GWT.create(ObjectReader1.class);
        }
        return objectreader1;
    }

    private static ObjectReader2 getObjectReader2() {
        if (objectreader2 == null) {
            objectreader2 = (ObjectReader2)GWT.create(ObjectReader2.class);
        }
        return objectreader2;
    }

    private static ObjectMapper1 getObjectMapper1() {
        if (objectmapper1 == null) {
            objectmapper1 = (ObjectMapper1)GWT.create(ObjectMapper1.class);
        }
        return objectmapper1;
    }

    public static final RestRequestBuilder<Void, List<Contract>> getContractList(Integer tenantId) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/contract/").addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)ContractRestServiceBuilder.getObjectReader1());
    }

    public static final Request getContractList(Integer tenantId, RestCallback<List<Contract>> _callback_) {
        return ContractRestServiceBuilder.getContractList(tenantId).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Contract> getContract(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.GET).url("/tenant/{tenantId}/contract/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)ContractRestServiceBuilder.getObjectMapper1());
    }

    public static final Request getContract(Integer tenantId, Long id, RestCallback<Contract> _callback_) {
        return ContractRestServiceBuilder.getContract(tenantId, id).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Contract, Contract> addContract(Integer tenantId, Contract contract) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/contract/add").body((Object)contract).bodyConverter((ObjectWriter)ContractRestServiceBuilder.getObjectMapper1()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)ContractRestServiceBuilder.getObjectMapper1());
    }

    public static final Request addContract(Integer tenantId, Contract contract, RestCallback<Contract> _callback_) {
        return ContractRestServiceBuilder.addContract(tenantId, contract).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Contract, Contract> updateContract(Integer tenantId, Contract contract) {
        return new RestRequestBuilder().method(RequestBuilder.POST).url("/tenant/{tenantId}/contract/update").body((Object)contract).bodyConverter((ObjectWriter)ContractRestServiceBuilder.getObjectMapper1()).addPathParam("tenantId", (Object)tenantId).responseConverter((ObjectReader)ContractRestServiceBuilder.getObjectMapper1());
    }

    public static final Request updateContract(Integer tenantId, Contract contract, RestCallback<Contract> _callback_) {
        return ContractRestServiceBuilder.updateContract(tenantId, contract).callback(_callback_).send();
    }

    public static final RestRequestBuilder<Void, Boolean> removeContract(Integer tenantId, Long id) {
        return new RestRequestBuilder().method(RequestBuilder.DELETE).url("/tenant/{tenantId}/contract/{id}").addPathParam("tenantId", (Object)tenantId).addPathParam("id", (Object)id).responseConverter((ObjectReader)ContractRestServiceBuilder.getObjectReader2());
    }

    public static final Request removeContract(Integer tenantId, Long id, RestCallback<Boolean> _callback_) {
        return ContractRestServiceBuilder.removeContract(tenantId, id).callback(_callback_).send();
    }

    static interface ObjectMapper1
    extends ObjectMapper<Contract> {
    }

    static interface ObjectReader2
    extends ObjectReader<Boolean> {
    }

    static interface ObjectReader1
    extends ObjectReader<List<Contract>> {
    }
}

