/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.employee;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.employee.view.EmployeeAvailabilityView;

@Api(tags={"Employee"})
@Path(value="/tenant/{tenantId}/employee")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface EmployeeRestService {
    @ApiOperation(value="Get a list of all employees")
    @GET
    @Path(value="/")
    public List<Employee> getEmployeeList(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1);

    @ApiOperation(value="Get an employee by id")
    @GET
    @Path(value="/{id}")
    public Employee getEmployee(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(required=true) @PathParam(value="id") Long var2);

    @ApiOperation(value="Add a new employee")
    @POST
    @Path(value="/add")
    public Employee addEmployee(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(value="with no id", required=true) Employee var2);

    @ApiOperation(value="Update an employee")
    @POST
    @Path(value="/update")
    public Employee updateEmployee(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(required=true) Employee var2);

    @ApiOperation(value="Delete an employee")
    @DELETE
    @Path(value="/{id}")
    public Boolean removeEmployee(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(required=true) @PathParam(value="id") Long var2);

    @POST
    @Path(value="/availability/add")
    public EmployeeAvailabilityView addEmployeeAvailability(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(value="with no id", required=true) EmployeeAvailabilityView var2);

    @PUT
    @Path(value="/availability/update")
    public EmployeeAvailabilityView updateEmployeeAvailability(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(required=true) EmployeeAvailabilityView var2);

    @DELETE
    @Path(value="/availability/{id}")
    public Boolean removeEmployeeAvailability(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(required=true) @PathParam(value="id") Long var2);
}

