/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.rotation;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.validation.constraints.NotNull;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.shared.shift.Shift;
import org.optaweb.employeerostering.shared.spot.Spot;

@Entity
@NamedQueries(value={@NamedQuery(name="ShiftTemplate.findAll", query="select distinct sa from ShiftTemplate sa left join fetch sa.spot s left join fetch sa.rotationEmployee re where sa.tenantId = :tenantId order by sa.startDayOffset, sa.startTime, s.name, re.name"), @NamedQuery(name="ShiftTemplate.deleteForTenant", query="delete from ShiftTemplate st where st.tenantId = :tenantId")})
public class ShiftTemplate
extends AbstractPersistable {
    @NotNull
    @ManyToOne
    private Spot spot;
    @NotNull
    private Integer startDayOffset;
    @NotNull
    private LocalTime startTime;
    @NotNull
    private Integer endDayOffset;
    @NotNull
    private LocalTime endTime;
    @ManyToOne
    private Employee rotationEmployee;

    public ShiftTemplate() {
    }

    public ShiftTemplate(Integer tenantId, Spot spot, int startDayOffset, LocalTime startTime, int endDayOffset, LocalTime endTime) {
        this(tenantId, spot, startDayOffset, startTime, endDayOffset, endTime, null);
    }

    public ShiftTemplate(Integer tenantId, Spot spot, int startDayOffset, LocalTime startTime, int endDayOffset, LocalTime endTime, Employee rotationEmployee) {
        super(tenantId);
        this.rotationEmployee = rotationEmployee;
        this.spot = spot;
        this.startDayOffset = startDayOffset;
        this.endDayOffset = endDayOffset;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public ShiftTemplate(Integer rotationLength, ShiftTemplateView shiftTemplateView, Spot spot, Employee rotationEmployee) {
        super(shiftTemplateView);
        this.spot = spot;
        this.rotationEmployee = rotationEmployee;
        this.startDayOffset = (int)shiftTemplateView.getDurationBetweenRotationStartAndTemplateStart().toDays();
        this.startTime = LocalTime.ofSecondOfDay(shiftTemplateView.getDurationBetweenRotationStartAndTemplateStart().minusDays(this.startDayOffset.intValue()).getSeconds());
        int endDayAfterStartDay = (int)shiftTemplateView.getDurationBetweenRotationStartAndTemplateStart().plus(shiftTemplateView.getShiftTemplateDuration()).toDays();
        this.endTime = LocalTime.ofSecondOfDay(shiftTemplateView.getDurationBetweenRotationStartAndTemplateStart().plus(shiftTemplateView.getDurationOfTimeslot()).minusDays(endDayAfterStartDay).getSeconds());
        this.endDayOffset = endDayAfterStartDay % rotationLength;
    }

    public Shift createShiftOnDate(LocalDate startDate, int rotationLength, ZoneId zoneId, boolean defaultToRotationEmployee) {
        LocalDateTime startDateTime = startDate.atTime(this.getStartTime());
        LocalDate endDate = this.getStartDayOffset() <= this.getEndDayOffset() ? startDate.plusDays(this.getEndDayOffset() - this.getStartDayOffset()) : startDate.plusDays(rotationLength + this.getEndDayOffset() - this.getStartDayOffset());
        LocalDateTime endDateTime = endDate.atTime(this.getEndTime());
        OffsetDateTime startOffsetDateTime = OffsetDateTime.of(startDateTime, zoneId.getRules().getOffset(startDateTime));
        OffsetDateTime endOffsetDateTime = OffsetDateTime.of(endDateTime, zoneId.getRules().getOffset(endDateTime));
        Shift shift = new Shift(this.getTenantId(), this.getSpot(), startOffsetDateTime, endOffsetDateTime, this.rotationEmployee);
        if (defaultToRotationEmployee) {
            shift.setEmployee(this.rotationEmployee);
        }
        return shift;
    }

    public Spot getSpot() {
        return this.spot;
    }

    public void setSpot(Spot spot) {
        this.spot = spot;
    }

    public Integer getStartDayOffset() {
        return this.startDayOffset;
    }

    public void setStartDayOffset(Integer offsetStartDay) {
        this.startDayOffset = offsetStartDay;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public Integer getEndDayOffset() {
        return this.endDayOffset;
    }

    public void setEndDayOffset(Integer offsetEndDay) {
        this.endDayOffset = offsetEndDay;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public Employee getRotationEmployee() {
        return this.rotationEmployee;
    }

    public void setRotationEmployee(Employee rotationEmployee) {
        this.rotationEmployee = rotationEmployee;
    }
}

