/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.skill;

import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;

@Entity
@NamedQueries(value={@NamedQuery(name="Skill.findAll", query="select s from Skill s where s.tenantId = :tenantId order by LOWER(s.name)"), @NamedQuery(name="Skill.deleteForTenant", query="delete from Skill s where s.tenantId = :tenantId")})
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tenantId", "name"})})
public class Skill
extends AbstractPersistable {
    @NotNull
    @Size(min=1, max=120)
    @Pattern(regexp="^(?!\\s).*(?<!\\s)$", message="Name should not contain any leading or trailing whitespaces")
    private String name;

    public Skill() {
    }

    public Skill(Integer tenantId, String name) {
        super(tenantId);
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

