/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.violation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.violation.ConstraintMatchView;

public class ContractMinutesViolation
implements ConstraintMatchView {
    private Employee employee;
    private Type type;
    private Long minutesWorked;
    private HardMediumSoftLongScore score;

    public ContractMinutesViolation() {
    }

    public ContractMinutesViolation(Employee employee, Type type, Long minutesWorked, HardMediumSoftLongScore score) {
        this.employee = employee;
        this.type = type;
        this.minutesWorked = minutesWorked;
        this.score = score;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Long getMinutesWorked() {
        return this.minutesWorked;
    }

    public void setMinutesWorked(Long minutesWorked) {
        this.minutesWorked = minutesWorked;
    }

    @JsonIgnore
    public Integer getMaximumMinutesWorked() {
        switch (this.type) {
            case DAY: {
                return this.employee.getContract().getMaximumMinutesPerDay();
            }
            case MONTH: {
                return this.employee.getContract().getMaximumMinutesPerMonth();
            }
            case WEEK: {
                return this.employee.getContract().getMaximumMinutesPerWeek();
            }
            case YEAR: {
                return this.employee.getContract().getMaximumMinutesPerYear();
            }
        }
        throw new IllegalStateException("No case in getMaximumMinutesWorked() for \"" + this.type.name() + "\".");
    }

    @Override
    public HardMediumSoftLongScore getScore() {
        return this.score;
    }

    public void setScore(HardMediumSoftLongScore score) {
        this.score = score;
    }

    public static enum Type {
        DAY("daily"),
        WEEK("weekly"),
        MONTH("monthly"),
        YEAR("yearly");

        private String typeString;

        private Type(String typeString) {
            this.typeString = typeString;
        }

        public static Type getTypeForViolation(String constraintName) {
            if (constraintName.equals("Daily minutes must not exceed contract maximum")) {
                return DAY;
            }
            if (constraintName.equals("Weekly minutes must not exceed contract maximum")) {
                return WEEK;
            }
            if (constraintName.equals("Monthly minutes must not exceed contract maximum")) {
                return MONTH;
            }
            if (constraintName.equals("Yearly minutes must not exceed contract maximum")) {
                return YEAR;
            }
            throw new IllegalArgumentException("No ContractMinutesViolation.Type correspond to " + constraintName);
        }

        public String toString() {
            return this.typeString;
        }
    }
}

