package org.optaweb.employeerostering.shared.contract;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Void;
import java.util.List;

/**
 * Generated REST service builder for {@link org.optaweb.employeerostering.shared.contract.ContractRestService}.
 */
public final class ContractRestServiceBuilder {
  private static ObjectReader1 objectreader1;

  private static ObjectReader2 objectreader2;

  private static ObjectMapper1 objectmapper1;

  private ContractRestServiceBuilder() {
  }

  private static ObjectReader1 getObjectReader1() {
    if (objectreader1 == null) {
      objectreader1 = GWT.create(ObjectReader1.class);
    }
    return objectreader1;
  }

  private static ObjectReader2 getObjectReader2() {
    if (objectreader2 == null) {
      objectreader2 = GWT.create(ObjectReader2.class);
    }
    return objectreader2;
  }

  private static ObjectMapper1 getObjectMapper1() {
    if (objectmapper1 == null) {
      objectmapper1 = GWT.create(ObjectMapper1.class);
    }
    return objectmapper1;
  }

  public static final RestRequestBuilder<Void, List<Contract>> getContractList(final Integer tenantId) {
    return new RestRequestBuilder<Void, List<Contract>>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/contract/")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectReader1());
  }

  public static final Request getContractList(final Integer tenantId, RestCallback<List<Contract>> _callback_) {
    return getContractList(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Contract> getContract(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Contract>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/contract/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectMapper1());
  }

  public static final Request getContract(final Integer tenantId, final Long id, RestCallback<Contract> _callback_) {
    return getContract(tenantId, id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Contract, Contract> addContract(final Integer tenantId, final Contract contract) {
    return new RestRequestBuilder<Contract, Contract>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/contract/add")
          .body(contract)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request addContract(final Integer tenantId, final Contract contract, RestCallback<Contract> _callback_) {
    return addContract(tenantId, contract)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Contract, Contract> updateContract(final Integer tenantId, final Contract contract) {
    return new RestRequestBuilder<Contract, Contract>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/contract/update")
          .body(contract)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request updateContract(final Integer tenantId, final Contract contract, RestCallback<Contract> _callback_) {
    return updateContract(tenantId, contract)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Boolean> removeContract(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Boolean>()
          .method(RequestBuilder.DELETE)
          .url("/tenant/{tenantId}/contract/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectReader2());
  }

  public static final Request removeContract(final Integer tenantId, final Long id, RestCallback<Boolean> _callback_) {
    return removeContract(tenantId, id)
          .callback(_callback_)
          .send();
  }

  interface ObjectReader1 extends ObjectReader<List<Contract>> {
  }

  interface ObjectReader2 extends ObjectReader<Boolean> {
  }

  interface ObjectMapper1 extends ObjectMapper<Contract> {
  }
}
