package org.optaweb.employeerostering.shared.roster;

import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.client.ObjectWriter;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.lang.Integer;
import java.lang.String;
import java.lang.Void;
import java.util.List;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.shared.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.shared.spot.Spot;

/**
 * Generated REST service builder for {@link org.optaweb.employeerostering.shared.roster.RosterRestService}.
 */
public final class RosterRestServiceBuilder {
  private static ObjectReader1 objectreader1;

  private static ObjectReader2 objectreader2;

  private static ObjectReader3 objectreader3;

  private static ObjectReader4 objectreader4;

  private static ObjectWriter1 objectwriter1;

  private static ObjectWriter2 objectwriter2;

  private RosterRestServiceBuilder() {
  }

  private static ObjectReader1 getObjectReader1() {
    if (objectreader1 == null) {
      objectreader1 = GWT.create(ObjectReader1.class);
    }
    return objectreader1;
  }

  private static ObjectReader2 getObjectReader2() {
    if (objectreader2 == null) {
      objectreader2 = GWT.create(ObjectReader2.class);
    }
    return objectreader2;
  }

  private static ObjectReader3 getObjectReader3() {
    if (objectreader3 == null) {
      objectreader3 = GWT.create(ObjectReader3.class);
    }
    return objectreader3;
  }

  private static ObjectReader4 getObjectReader4() {
    if (objectreader4 == null) {
      objectreader4 = GWT.create(ObjectReader4.class);
    }
    return objectreader4;
  }

  private static ObjectWriter1 getObjectWriter1() {
    if (objectwriter1 == null) {
      objectwriter1 = GWT.create(ObjectWriter1.class);
    }
    return objectwriter1;
  }

  private static ObjectWriter2 getObjectWriter2() {
    if (objectwriter2 == null) {
      objectwriter2 = GWT.create(ObjectWriter2.class);
    }
    return objectwriter2;
  }

  public static final RestRequestBuilder<Void, RosterState> getRosterState(final Integer tenantId) {
    return new RestRequestBuilder<Void, RosterState>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/roster/state")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectReader1());
  }

  public static final Request getRosterState(final Integer tenantId, RestCallback<RosterState> _callback_) {
    return getRosterState(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, ShiftRosterView> getCurrentShiftRosterView(final Integer tenantId, final Integer pageNumber, final Integer numberOfItemsPerPage) {
    return new RestRequestBuilder<Void, ShiftRosterView>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/roster/shiftRosterView/current")
          .addPathParam("tenantId", tenantId)
          .addQueryParam("p", pageNumber)
          .addQueryParam("n", numberOfItemsPerPage)
          .responseConverter(getObjectReader2());
  }

  public static final Request getCurrentShiftRosterView(final Integer tenantId, final Integer pageNumber, final Integer numberOfItemsPerPage, RestCallback<ShiftRosterView> _callback_) {
    return getCurrentShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, ShiftRosterView> getShiftRosterView(final Integer tenantId, final Integer pageNumber, final Integer numberOfItemsPerPage, final String startDateString, final String endDateString) {
    return new RestRequestBuilder<Void, ShiftRosterView>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/roster/shiftRosterView")
          .addPathParam("tenantId", tenantId)
          .addQueryParam("p", pageNumber)
          .addQueryParam("n", numberOfItemsPerPage)
          .addQueryParam("startDate", startDateString)
          .addQueryParam("endDate", endDateString)
          .responseConverter(getObjectReader2());
  }

  public static final Request getShiftRosterView(final Integer tenantId, final Integer pageNumber, final Integer numberOfItemsPerPage, final String startDateString, final String endDateString, RestCallback<ShiftRosterView> _callback_) {
    return getShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<List<Spot>, ShiftRosterView> getShiftRosterViewFor(final Integer tenantId, final String startDateString, final String endDateString, final List<Spot> spots) {
    return new RestRequestBuilder<List<Spot>, ShiftRosterView>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/roster/shiftRosterView/for")
          .body(spots)
          .bodyConverter(getObjectWriter1())
          .addPathParam("tenantId", tenantId)
          .addQueryParam("startDate", startDateString)
          .addQueryParam("endDate", endDateString)
          .responseConverter(getObjectReader2());
  }

  public static final Request getShiftRosterViewFor(final Integer tenantId, final String startDateString, final String endDateString, final List<Spot> spots, RestCallback<ShiftRosterView> _callback_) {
    return getShiftRosterViewFor(tenantId, startDateString, endDateString, spots)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, AvailabilityRosterView> getCurrentAvailabilityRosterView(final Integer tenantId, final Integer pageNumber, final Integer numberOfItemsPerPage) {
    return new RestRequestBuilder<Void, AvailabilityRosterView>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/roster/availabilityRosterView/current")
          .addPathParam("tenantId", tenantId)
          .addQueryParam("p", pageNumber)
          .addQueryParam("n", numberOfItemsPerPage)
          .responseConverter(getObjectReader3());
  }

  public static final Request getCurrentAvailabilityRosterView(final Integer tenantId, final Integer pageNumber, final Integer numberOfItemsPerPage, RestCallback<AvailabilityRosterView> _callback_) {
    return getCurrentAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, AvailabilityRosterView> getAvailabilityRosterView(final Integer tenantId, final Integer pageNumber, final Integer numberOfItemsPerPage, final String startDateString, final String endDateString) {
    return new RestRequestBuilder<Void, AvailabilityRosterView>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/roster/availabilityRosterView")
          .addPathParam("tenantId", tenantId)
          .addQueryParam("p", pageNumber)
          .addQueryParam("n", numberOfItemsPerPage)
          .addQueryParam("startDate", startDateString)
          .addQueryParam("endDate", endDateString)
          .responseConverter(getObjectReader3());
  }

  public static final Request getAvailabilityRosterView(final Integer tenantId, final Integer pageNumber, final Integer numberOfItemsPerPage, final String startDateString, final String endDateString, RestCallback<AvailabilityRosterView> _callback_) {
    return getAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<List<Employee>, AvailabilityRosterView> getAvailabilityRosterViewFor(final Integer tenantId, final String startDateString, final String endDateString, final List<Employee> employees) {
    return new RestRequestBuilder<List<Employee>, AvailabilityRosterView>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/roster/availabilityRosterView/for")
          .body(employees)
          .bodyConverter(getObjectWriter2())
          .addPathParam("tenantId", tenantId)
          .addQueryParam("startDate", startDateString)
          .addQueryParam("endDate", endDateString)
          .responseConverter(getObjectReader3());
  }

  public static final Request getAvailabilityRosterViewFor(final Integer tenantId, final String startDateString, final String endDateString, final List<Employee> employees, RestCallback<AvailabilityRosterView> _callback_) {
    return getAvailabilityRosterViewFor(tenantId, startDateString, endDateString, employees)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Void> solveRoster(final Integer tenantId) {
    return new RestRequestBuilder<Void, Void>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/roster/solve")
          .addPathParam("tenantId", tenantId);
  }

  public static final Request solveRoster(final Integer tenantId, RestCallback<Void> _callback_) {
    return solveRoster(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Void> terminateRosterEarly(final Integer tenantId) {
    return new RestRequestBuilder<Void, Void>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/roster/terminate")
          .addPathParam("tenantId", tenantId);
  }

  public static final Request terminateRosterEarly(final Integer tenantId, RestCallback<Void> _callback_) {
    return terminateRosterEarly(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, PublishResult> publishAndProvision(final Integer tenantId) {
    return new RestRequestBuilder<Void, PublishResult>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/roster/publishAndProvision")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectReader4());
  }

  public static final Request publishAndProvision(final Integer tenantId, RestCallback<PublishResult> _callback_) {
    return publishAndProvision(tenantId)
          .callback(_callback_)
          .send();
  }

  interface ObjectReader1 extends ObjectReader<RosterState> {
  }

  interface ObjectReader2 extends ObjectReader<ShiftRosterView> {
  }

  interface ObjectReader3 extends ObjectReader<AvailabilityRosterView> {
  }

  interface ObjectReader4 extends ObjectReader<PublishResult> {
  }

  interface ObjectWriter1 extends ObjectWriter<List<Spot>> {
  }

  interface ObjectWriter2 extends ObjectWriter<List<Employee>> {
  }
}
