package org.optaweb.employeerostering.shared.rotation;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Void;
import java.util.List;
import org.optaweb.employeerostering.shared.rotation.view.ShiftTemplateView;

/**
 * Generated REST service builder for {@link org.optaweb.employeerostering.shared.rotation.RotationRestService}.
 */
public final class RotationRestServiceBuilder {
  private static ObjectReader1 objectreader1;

  private static ObjectReader2 objectreader2;

  private static ObjectMapper1 objectmapper1;

  private RotationRestServiceBuilder() {
  }

  private static ObjectReader1 getObjectReader1() {
    if (objectreader1 == null) {
      objectreader1 = GWT.create(ObjectReader1.class);
    }
    return objectreader1;
  }

  private static ObjectReader2 getObjectReader2() {
    if (objectreader2 == null) {
      objectreader2 = GWT.create(ObjectReader2.class);
    }
    return objectreader2;
  }

  private static ObjectMapper1 getObjectMapper1() {
    if (objectmapper1 == null) {
      objectmapper1 = GWT.create(ObjectMapper1.class);
    }
    return objectmapper1;
  }

  public static final RestRequestBuilder<Void, List<ShiftTemplateView>> getShiftTemplateList(final Integer tenantId) {
    return new RestRequestBuilder<Void, List<ShiftTemplateView>>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/rotation/")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectReader1());
  }

  public static final Request getShiftTemplateList(final Integer tenantId, RestCallback<List<ShiftTemplateView>> _callback_) {
    return getShiftTemplateList(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, ShiftTemplateView> getShiftTemplate(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, ShiftTemplateView>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/rotation/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectMapper1());
  }

  public static final Request getShiftTemplate(final Integer tenantId, final Long id, RestCallback<ShiftTemplateView> _callback_) {
    return getShiftTemplate(tenantId, id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<ShiftTemplateView, ShiftTemplateView> addShiftTemplate(final Integer tenantId, final ShiftTemplateView shiftTemplate) {
    return new RestRequestBuilder<ShiftTemplateView, ShiftTemplateView>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/rotation/add")
          .body(shiftTemplate)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request addShiftTemplate(final Integer tenantId, final ShiftTemplateView shiftTemplate, RestCallback<ShiftTemplateView> _callback_) {
    return addShiftTemplate(tenantId, shiftTemplate)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<ShiftTemplateView, ShiftTemplateView> updateShiftTemplate(final Integer tenantId, final ShiftTemplateView shiftTemplate) {
    return new RestRequestBuilder<ShiftTemplateView, ShiftTemplateView>()
          .method(RequestBuilder.PUT)
          .url("/tenant/{tenantId}/rotation/update")
          .body(shiftTemplate)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request updateShiftTemplate(final Integer tenantId, final ShiftTemplateView shiftTemplate, RestCallback<ShiftTemplateView> _callback_) {
    return updateShiftTemplate(tenantId, shiftTemplate)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Boolean> removeShiftTemplate(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Boolean>()
          .method(RequestBuilder.DELETE)
          .url("/tenant/{tenantId}/rotation/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectReader2());
  }

  public static final Request removeShiftTemplate(final Integer tenantId, final Long id, RestCallback<Boolean> _callback_) {
    return removeShiftTemplate(tenantId, id)
          .callback(_callback_)
          .send();
  }

  interface ObjectReader1 extends ObjectReader<List<ShiftTemplateView>> {
  }

  interface ObjectReader2 extends ObjectReader<Boolean> {
  }

  interface ObjectMapper1 extends ObjectMapper<ShiftTemplateView> {
  }
}
