package org.optaweb.employeerostering.shared.spot;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Void;
import java.util.List;

/**
 * Generated REST service builder for {@link org.optaweb.employeerostering.shared.spot.SpotRestService}.
 */
public final class SpotRestServiceBuilder {
  private static ObjectReader1 objectreader1;

  private static ObjectReader2 objectreader2;

  private static ObjectMapper1 objectmapper1;

  private SpotRestServiceBuilder() {
  }

  private static ObjectReader1 getObjectReader1() {
    if (objectreader1 == null) {
      objectreader1 = GWT.create(ObjectReader1.class);
    }
    return objectreader1;
  }

  private static ObjectReader2 getObjectReader2() {
    if (objectreader2 == null) {
      objectreader2 = GWT.create(ObjectReader2.class);
    }
    return objectreader2;
  }

  private static ObjectMapper1 getObjectMapper1() {
    if (objectmapper1 == null) {
      objectmapper1 = GWT.create(ObjectMapper1.class);
    }
    return objectmapper1;
  }

  public static final RestRequestBuilder<Void, List<Spot>> getSpotList(final Integer tenantId) {
    return new RestRequestBuilder<Void, List<Spot>>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/spot/")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectReader1());
  }

  public static final Request getSpotList(final Integer tenantId, RestCallback<List<Spot>> _callback_) {
    return getSpotList(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Spot> getSpot(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Spot>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/spot/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectMapper1());
  }

  public static final Request getSpot(final Integer tenantId, final Long id, RestCallback<Spot> _callback_) {
    return getSpot(tenantId, id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Spot, Spot> addSpot(final Integer tenantId, final Spot spot) {
    return new RestRequestBuilder<Spot, Spot>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/spot/add")
          .body(spot)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request addSpot(final Integer tenantId, final Spot spot, RestCallback<Spot> _callback_) {
    return addSpot(tenantId, spot)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Spot, Spot> updateSpot(final Integer tenantId, final Spot spot) {
    return new RestRequestBuilder<Spot, Spot>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/spot/update")
          .body(spot)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request updateSpot(final Integer tenantId, final Spot spot, RestCallback<Spot> _callback_) {
    return updateSpot(tenantId, spot)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Boolean> removeSpot(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Boolean>()
          .method(RequestBuilder.DELETE)
          .url("/tenant/{tenantId}/spot/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectReader2());
  }

  public static final Request removeSpot(final Integer tenantId, final Long id, RestCallback<Boolean> _callback_) {
    return removeSpot(tenantId, id)
          .callback(_callback_)
          .send();
  }

  interface ObjectReader1 extends ObjectReader<List<Spot>> {
  }

  interface ObjectReader2 extends ObjectReader<Boolean> {
  }

  interface ObjectMapper1 extends ObjectMapper<Spot> {
  }
}
