package org.optaweb.employeerostering.shared.tenant;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.client.ObjectWriter;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Void;
import java.time.ZoneId;
import java.util.List;
import org.optaweb.employeerostering.shared.roster.RosterState;

/**
 * Generated REST service builder for {@link org.optaweb.employeerostering.shared.tenant.TenantRestService}.
 */
public final class TenantRestServiceBuilder {
  private static ObjectReader1 objectreader1;

  private static ObjectReader2 objectreader2;

  private static ObjectReader3 objectreader3;

  private static ObjectReader4 objectreader4;

  private static ObjectWriter1 objectwriter1;

  private static ObjectMapper1 objectmapper1;

  private TenantRestServiceBuilder() {
  }

  private static ObjectReader1 getObjectReader1() {
    if (objectreader1 == null) {
      objectreader1 = GWT.create(ObjectReader1.class);
    }
    return objectreader1;
  }

  private static ObjectReader2 getObjectReader2() {
    if (objectreader2 == null) {
      objectreader2 = GWT.create(ObjectReader2.class);
    }
    return objectreader2;
  }

  private static ObjectReader3 getObjectReader3() {
    if (objectreader3 == null) {
      objectreader3 = GWT.create(ObjectReader3.class);
    }
    return objectreader3;
  }

  private static ObjectReader4 getObjectReader4() {
    if (objectreader4 == null) {
      objectreader4 = GWT.create(ObjectReader4.class);
    }
    return objectreader4;
  }

  private static ObjectWriter1 getObjectWriter1() {
    if (objectwriter1 == null) {
      objectwriter1 = GWT.create(ObjectWriter1.class);
    }
    return objectwriter1;
  }

  private static ObjectMapper1 getObjectMapper1() {
    if (objectmapper1 == null) {
      objectmapper1 = GWT.create(ObjectMapper1.class);
    }
    return objectmapper1;
  }

  public static final RestRequestBuilder<Void, List<Tenant>> getTenantList() {
    return new RestRequestBuilder<Void, List<Tenant>>()
          .method(RequestBuilder.GET)
          .url("/tenant/")
          .responseConverter(getObjectReader1());
  }

  public static final Request getTenantList(RestCallback<List<Tenant>> _callback_) {
    return getTenantList()
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Tenant> getTenant(final Integer id) {
    return new RestRequestBuilder<Void, Tenant>()
          .method(RequestBuilder.GET)
          .url("/tenant/{id : \\d+}")
          .addPathParam("id", id)
          .responseConverter(getObjectReader2());
  }

  public static final Request getTenant(final Integer id, RestCallback<Tenant> _callback_) {
    return getTenant(id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<RosterState, Tenant> addTenant(final RosterState intialRosterState) {
    return new RestRequestBuilder<RosterState, Tenant>()
          .method(RequestBuilder.POST)
          .url("/tenant/add")
          .body(intialRosterState)
          .bodyConverter(getObjectWriter1())
          .responseConverter(getObjectReader2());
  }

  public static final Request addTenant(final RosterState intialRosterState, RestCallback<Tenant> _callback_) {
    return addTenant(intialRosterState)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Boolean> removeTenant(final Integer id) {
    return new RestRequestBuilder<Void, Boolean>()
          .method(RequestBuilder.POST)
          .url("/tenant/remove/{id}")
          .addPathParam("id", id)
          .responseConverter(getObjectReader3());
  }

  public static final Request removeTenant(final Integer id, RestCallback<Boolean> _callback_) {
    return removeTenant(id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, RosterParametrization> getRosterParametrization(final Integer id) {
    return new RestRequestBuilder<Void, RosterParametrization>()
          .method(RequestBuilder.GET)
          .url("/tenant/{id}")
          .addPathParam("id", id)
          .responseConverter(getObjectMapper1());
  }

  public static final Request getRosterParametrization(final Integer id, RestCallback<RosterParametrization> _callback_) {
    return getRosterParametrization(id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<RosterParametrization, RosterParametrization> updateRosterParametrization(final RosterParametrization rosterParametrization) {
    return new RestRequestBuilder<RosterParametrization, RosterParametrization>()
          .method(RequestBuilder.POST)
          .url("/tenant/parametrization/update")
          .body(rosterParametrization)
          .bodyConverter(getObjectMapper1())
          .responseConverter(getObjectMapper1());
  }

  public static final Request updateRosterParametrization(final RosterParametrization rosterParametrization, RestCallback<RosterParametrization> _callback_) {
    return updateRosterParametrization(rosterParametrization)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, List<ZoneId>> getSupportedTimezones() {
    return new RestRequestBuilder<Void, List<ZoneId>>()
          .method(RequestBuilder.GET)
          .url("/tenant/supported/timezones")
          .responseConverter(getObjectReader4());
  }

  public static final Request getSupportedTimezones(RestCallback<List<ZoneId>> _callback_) {
    return getSupportedTimezones()
          .callback(_callback_)
          .send();
  }

  interface ObjectReader1 extends ObjectReader<List<Tenant>> {
  }

  interface ObjectReader2 extends ObjectReader<Tenant> {
  }

  interface ObjectReader3 extends ObjectReader<Boolean> {
  }

  interface ObjectReader4 extends ObjectReader<List<ZoneId>> {
  }

  interface ObjectWriter1 extends ObjectWriter<RosterState> {
  }

  interface ObjectMapper1 extends ObjectMapper<RosterParametrization> {
  }
}
