import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/AppLauncher/app-launcher';
import accessibleStyles from '@patternfly/react-styles/css/utilities/Accessibility/accessibility';
import { DropdownItem } from '../Dropdown';
import { ApplicationLauncherIcon } from './InternalApplicationLauncherIcon';
import { ApplicationLauncherText } from './InternalApplicationLauncherText';
import { ExternalLinkAltIcon } from '@patternfly/react-icons';
export const ApplicationLauncherItem = (_ref) => {
  let {
    className = '',
    children,
    icon = null,
    isExternal = false,
    href,
    tooltip = null,
    tooltipProps = null
  } = _ref,
      props = _objectWithoutProperties(_ref, ["className", "children", "icon", "isExternal", "href", "tooltip", "tooltipProps"]);

  return React.createElement(DropdownItem, _extends({
    component: href ? 'a' : 'div',
    href: href || null,
    className: css(isExternal && styles.modifiers.external, className) // add style until https://github.com/patternfly/patternfly-next/issues/1944 is fixed
    ,
    style: !href ? {
      cursor: 'pointer'
    } : null,
    tooltip: tooltip,
    tooltipProps: tooltipProps
  }, props), icon && React.createElement(ApplicationLauncherIcon, null, icon), icon ? React.createElement(ApplicationLauncherText, null, children) : children, isExternal && React.createElement(React.Fragment, null, React.createElement("span", {
    className: css(styles.appLauncherMenuItemExternalIcon)
  }, React.createElement(ExternalLinkAltIcon, null)), React.createElement("span", {
    className: css(accessibleStyles.screenReader)
  }, "(opens new window)")));
};
ApplicationLauncherItem.propTypes = {
  icon: _pt.node,
  isExternal: _pt.bool,
  tooltip: _pt.node,
  tooltipProps: _pt.any
};
//# sourceMappingURL=ApplicationLauncherItem.js.map