import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from 'react';
import * as ReactDOM from 'react-dom';
import styles from '@patternfly/react-styles/css/components/Dropdown/dropdown';
import { css } from '@patternfly/react-styles';
import { keyHandler } from '../../helpers/util';
import { DropdownPosition, DropdownArrowContext, DropdownContext } from './dropdownConstants';
import { KEY_CODES, KEYHANDLER_DIRECTION } from '../../helpers/constants';
export class DropdownMenu extends React.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "refsCollection", []);

    _defineProperty(this, "childKeyHandler", (index, position, custom = false) => {
      keyHandler(index, position, this.refsCollection, this.props.isGrouped ? this.refsCollection : React.Children.toArray(this.props.children), custom);
    });

    _defineProperty(this, "sendRef", (index, node, isDisabled) => {
      if (!node.getAttribute) {
        // eslint-disable-line react/no-find-dom-node
        this.refsCollection[index] = {
          current: ReactDOM.findDOMNode(node)
        };
      } else if (isDisabled || node.getAttribute('role') === 'separator') {
        this.refsCollection[index] = null;
      } else {
        this.refsCollection[index] = node;
      }
    });
  }

  componentDidMount() {
    const {
      autoFocus
    } = this.props;

    if (this.props.component === 'ul' && autoFocus) {
      const focusTarget = this.refsCollection.find(ref => ref && ref.current && !ref.current.hasAttribute('disabled'));

      if (focusTarget && focusTarget.current) {
        if (focusTarget.current.focus) {
          focusTarget.current.focus();
        } else {
          const searchedFocusTarget = ReactDOM.findDOMNode(focusTarget.current);
          searchedFocusTarget.focus();
        }
      } else if (focusTarget) {
        ; // eslint-disable-line react/no-find-dom-node
      }
    }
  }

  extendChildren() {
    const {
      children,
      isGrouped
    } = this.props;

    if (isGrouped) {
      let index = 0;
      return React.Children.map(children, groupedChildren => {
        const group = groupedChildren;
        return React.cloneElement(group, {
          children: group.props.children.constructor === Array && React.Children.map(group.props.children, option => React.cloneElement(option, {
            index: index++
          })) || React.cloneElement(group.props.children, {
            index: index++
          })
        });
      });
    }

    return React.Children.map(children, (child, index) => React.cloneElement(child, {
      index
    }));
  }

  extendCustomChildren() {
    const mappedChildren = React.Children.map(this.props.children, (child0, index) => {
      const child = child0;
      const mappedChild = React.cloneElement(child, {
        ref: React.createRef(),
        className: `${css(child.props.isDisabled && styles.modifiers.disabled, child.props.isHovered && styles.modifiers.hover, styles.dropdownMenuItem)}${child.props.className ? child.props.className : ''}`,
        tabIndex: -1,
        onKeyDown: event => {
          if (event.keyCode === KEY_CODES.TAB) {
            return;
          }

          ;
          event.preventDefault();

          if (event.keyCode === KEY_CODES.ARROW_UP) {
            keyHandler(index, KEYHANDLER_DIRECTION.UP, this.refsCollection, React.Children.toArray(this.props.children), true);
          } else if (event.keyCode === KEY_CODES.ARROW_DOWN) {
            keyHandler(index, KEYHANDLER_DIRECTION.DOWN, this.refsCollection, React.Children.toArray(this.props.children), true);
          }
        }
      });
      !mappedChild.props.disabled ? this.refsCollection[index] = mappedChild.props.ref : this.refsCollection[index] = null;
      return mappedChild;
    });
    return mappedChildren;
  }

  render() {
    const _this$props = this.props,
          {
      className,
      isOpen,
      position,
      children,
      component,
      isGrouped,
      openedOnEnter
    } = _this$props,
          props = _objectWithoutProperties(_this$props, ["className", "isOpen", "position", "children", "component", "isGrouped", "openedOnEnter"]);

    const Component = component;
    return React.createElement(DropdownArrowContext.Provider, {
      value: {
        keyHandler: this.childKeyHandler,
        sendRef: this.sendRef
      }
    }, Component === 'div' ? React.createElement(DropdownContext.Consumer, null, ({
      onSelect,
      menuClass
    }) => React.createElement("ul", {
      className: css(menuClass, position === DropdownPosition.right && styles.modifiers.alignRight, className),
      hidden: !isOpen,
      onClick: event => onSelect && onSelect(event)
    }, React.createElement(Component, props, this.extendCustomChildren()))) : isGrouped && React.createElement(DropdownContext.Consumer, null, ({
      menuClass
    }) => React.createElement("div", _extends({}, props, {
      className: css(menuClass, position === DropdownPosition.right && styles.modifiers.alignRight, className),
      hidden: !isOpen,
      role: "menu"
    }), this.extendChildren())) || React.createElement(DropdownContext.Consumer, null, ({
      menuClass
    }) => React.createElement(Component, _extends({}, props, {
      className: css(menuClass, position === DropdownPosition.right && styles.modifiers.alignRight, className),
      hidden: !isOpen,
      role: "menu"
    }), this.extendChildren())));
  }

}

_defineProperty(DropdownMenu, "propTypes", {
  children: _pt.node,
  className: _pt.string,
  isOpen: _pt.bool,
  openedOnEnter: _pt.bool,
  autoFocus: _pt.bool,
  component: _pt.node,
  position: _pt.oneOfType([_pt.any, _pt.oneOf(['right']), _pt.oneOf(['left'])]),
  isGrouped: _pt.bool
});

_defineProperty(DropdownMenu, "defaultProps", {
  className: '',
  isOpen: true,
  openedOnEnter: false,
  autoFocus: true,
  position: DropdownPosition.left,
  component: 'ul',
  isGrouped: false
});
//# sourceMappingURL=DropdownMenu.js.map