import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from 'react';
import { css } from '@patternfly/react-styles';
import { DropdownContext } from './dropdownConstants';
import { KEY_CODES, KEYHANDLER_DIRECTION } from '../../helpers/constants';
import { Tooltip } from '../Tooltip';
export class InternalDropdownItem extends React.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "ref", React.createRef());

    _defineProperty(this, "onKeyDown", event => {
      // Detected key press on this item, notify the menu parent so that the appropriate
      // item can be focused
      if (event.keyCode === KEY_CODES.TAB) {
        return;
      }

      ;
      event.preventDefault();

      if (event.keyCode === KEY_CODES.ARROW_UP) {
        this.props.context.keyHandler(this.props.index, KEYHANDLER_DIRECTION.UP);
      } else if (event.keyCode === KEY_CODES.ARROW_DOWN) {
        this.props.context.keyHandler(this.props.index, KEYHANDLER_DIRECTION.DOWN);
      } else if (event.keyCode === KEY_CODES.ENTER && this.ref.current && this.ref.current.click) {
        this.ref.current.click();
      }
    });
  }

  componentDidMount() {
    this.props.context.sendRef(this.props.index, this.ref.current, this.props.isDisabled);
  }

  render() {
    const _this$props = this.props,
          {
      className,
      children,
      isHovered,
      context,
      onClick,
      component,
      isDisabled,
      index,
      href,
      tooltip,
      tooltipProps
    } = _this$props,
          additionalProps = _objectWithoutProperties(_this$props, ["className", "children", "isHovered", "context", "onClick", "component", "isDisabled", "index", "href", "tooltip", "tooltipProps"]);

    const Component = component;
    let classes;

    if (Component === 'a') {
      additionalProps['aria-disabled'] = isDisabled;
      additionalProps.tabIndex = isDisabled ? -1 : additionalProps.tabIndex;
    } else if (Component === 'button') {
      additionalProps.disabled = isDisabled;
      additionalProps.type = additionalProps.type || 'button';
    }

    const renderWithTooltip = childNode => tooltip ? React.createElement(Tooltip, _extends({
      content: tooltip
    }, tooltipProps), childNode) : childNode;

    return React.createElement(DropdownContext.Consumer, null, ({
      onSelect,
      itemClass,
      disabledClass,
      hoverClass
    }) => {
      if (this.props.role === 'separator') {
        classes = className;
      } else {
        classes = css(isDisabled && disabledClass, isHovered && hoverClass, className);
      }

      return React.createElement("li", {
        role: "none"
      }, React.isValidElement(children) ? React.Children.map(children, child => {
        const toClone = child;
        const clonedElement = React.cloneElement(toClone, {
          className: css(classes, itemClass),
          ref: this.ref,
          onKeyDown: this.onKeyDown,
          onClick: event => {
            if (!isDisabled) {
              onClick(event);
              onSelect(event);
            }
          }
        });
        return renderWithTooltip(clonedElement);
      }) : renderWithTooltip(React.createElement(Component, _extends({}, additionalProps, {
        href: href || null,
        className: css(classes, this.props.role !== 'separator' && itemClass),
        ref: this.ref,
        onKeyDown: this.onKeyDown,
        onClick: event => {
          if (!isDisabled) {
            onClick(event);
            onSelect(event);
          }
        }
      }), children)));
    });
  }

}

_defineProperty(InternalDropdownItem, "propTypes", {
  children: _pt.node,
  className: _pt.string,
  component: _pt.oneOfType([_pt.node, _pt.string]),
  role: _pt.string,
  isDisabled: _pt.bool,
  isHovered: _pt.bool,
  href: _pt.string,
  tooltip: _pt.node,
  tooltipProps: _pt.any,
  index: _pt.number,
  context: _pt.shape({
    keyHandler: _pt.func,
    sendRef: _pt.func
  }),
  onClick: _pt.func
});

_defineProperty(InternalDropdownItem, "defaultProps", {
  className: '',
  isHovered: false,
  component: 'a',
  isDisabled: false,
  href: '',
  tooltipProps: {},
  onClick: event => undefined,
  onSelect: () => undefined,
  index: -1,
  context: {
    keyHandler: Function.prototype,
    sendRef: Function.prototype
  }
});
//# sourceMappingURL=InternalDropdownItem.js.map