import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { canUseDOM } from 'exenv';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/Backdrop/backdrop';
import { KEY_CODES } from '../../helpers/constants';
import { ModalContent } from './ModalContent';
export class Modal extends React.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "id", '');

    _defineProperty(this, "handleEscKeyClick", event => {
      if (event.keyCode === KEY_CODES.ESCAPE_KEY && this.props.isOpen) {
        this.props.onClose();
      }
    });

    _defineProperty(this, "toggleSiblingsFromScreenReaders", hide => {
      const bodyChildren = document.body.children;

      for (const child of Array.from(bodyChildren)) {
        if (child !== this.state.container) {
          hide ? child.setAttribute('aria-hidden', '' + hide) : child.removeAttribute('aria-hidden');
        }
      }
    });

    const newId = Modal.currentId++;
    this.id = `pf-modal-${newId}`;
    this.state = {
      container: undefined
    };
  }

  componentDidMount() {
    const container = document.createElement('div');
    this.setState({
      container
    });
    document.body.appendChild(container);
    document.addEventListener('keydown', this.handleEscKeyClick, false);

    if (this.props.isOpen) {
      document.body.classList.add(css(styles.backdropOpen));
    } else {
      document.body.classList.remove(css(styles.backdropOpen));
    }
  }

  componentDidUpdate() {
    if (this.props.isOpen) {
      document.body.classList.add(css(styles.backdropOpen));
      this.toggleSiblingsFromScreenReaders(true);
    } else {
      document.body.classList.remove(css(styles.backdropOpen));
      this.toggleSiblingsFromScreenReaders(false);
    }
  }

  componentWillUnmount() {
    if (this.state.container) {
      document.body.removeChild(this.state.container);
    }

    document.removeEventListener('keydown', this.handleEscKeyClick, false);
    document.body.classList.remove(css(styles.backdropOpen));
  }

  render() {
    const props = _extends({}, this.props);

    const {
      container
    } = this.state;

    if (!canUseDOM || !container) {
      return null;
    }

    return ReactDOM.createPortal(React.createElement(ModalContent, _extends({}, props, {
      title: this.props.title,
      id: this.id,
      ariaDescribedById: this.props.ariaDescribedById
    })), container);
  }

}

_defineProperty(Modal, "propTypes", {
  children: _pt.node.isRequired,
  className: _pt.string,
  isOpen: _pt.bool,
  header: _pt.node,
  title: _pt.string.isRequired,
  hideTitle: _pt.bool,
  showClose: _pt.bool,
  ariaDescribedById: _pt.string,
  footer: _pt.node,
  actions: _pt.any,
  onClose: _pt.func,
  width: _pt.oneOfType([_pt.number, _pt.string]),
  isLarge: _pt.bool,
  isSmall: _pt.bool
});

_defineProperty(Modal, "currentId", 0);

_defineProperty(Modal, "defaultProps", {
  className: '',
  isOpen: false,
  hideTitle: false,
  showClose: true,
  ariaDescribedById: '',
  actions: [],
  onClose: () => undefined,
  isLarge: false,
  isSmall: false
});
//# sourceMappingURL=Modal.js.map