import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import { css, getModifier } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/OptionsMenu/options-menu';
import { CheckIcon } from '@patternfly/react-icons';
import { KEY_CODES } from '../../helpers';
export const OptionsMenuItem = (_ref) => {
  let {
    children = null,
    className = '',
    isSelected = false,
    isDisabled = false,
    onSelect = () => null,
    id = ''
  } = _ref,
      props = _objectWithoutProperties(_ref, ["children", "className", "isSelected", "isDisabled", "onSelect", "id"]);

  const onKeyDown = event => {
    // Detected key press on this item, notify the menu parent so that the appropriate
    // item can be focused
    if (event.keyCode === KEY_CODES.TAB) {
      return;
    }

    event.preventDefault();

    if (event.keyCode === KEY_CODES.ENTER) {
      onSelect(event);
    }
  };

  return React.createElement("li", null, React.createElement("button", _extends({
    className: css(styles.optionsMenuMenuItem, isDisabled && getModifier(styles, 'disabled'), className),
    "aria-disabled": isDisabled,
    onClick: onSelect,
    onKeyDown: onKeyDown,
    "aria-selected": isSelected,
    id: id
  }, props), children, React.createElement("i", {
    className: css(styles.optionsMenuMenuItemIcon),
    "aria-hidden": true,
    hidden: !isSelected
  }, React.createElement(CheckIcon, null))));
};
OptionsMenuItem.propTypes = {
  children: _pt.node,
  className: _pt.string,
  isSelected: _pt.bool,
  isDisabled: _pt.bool,
  onSelect: _pt.func,
  id: _pt.string
};
//# sourceMappingURL=OptionsMenuItem.js.map