import _pt from "prop-types";
import * as React from 'react';
import { CaretDownIcon } from '@patternfly/react-icons';
import styles from '@patternfly/react-styles/css/components/OptionsMenu/options-menu';
import { css, getModifier } from '@patternfly/react-styles';
export const OptionsMenuToggle = ({
  parentId = '',
  onToggle = () => null,
  isOpen = false,
  isPlain = false,
  isHovered = false,
  isActive = false,
  isFocused = false,
  isDisabled = false,
  toggleTemplate = React.createElement(React.Fragment, null),
  hideCaret = false,
  'aria-label': ariaLabel = 'Options menu'
}) => {
  return React.createElement("button", {
    className: css(styles.optionsMenuToggle, isPlain && getModifier(styles, 'plain'), isHovered && getModifier(styles, 'hover'), isActive && getModifier(styles, 'active'), isFocused && getModifier(styles, 'focus'), isDisabled && getModifier(styles, 'disabled')),
    id: `${parentId}-toggle`,
    "aria-haspopup": "listbox",
    "aria-label": ariaLabel,
    "aria-expanded": isOpen,
    onClick: onToggle
  }, toggleTemplate && (!isPlain ? React.createElement("span", {
    className: css(styles.optionsMenuToggleText)
  }, toggleTemplate) : React.createElement(React.Fragment, null, toggleTemplate)), !hideCaret && React.createElement(CaretDownIcon, {
    "aria-hidden": true,
    className: css(styles.optionsMenuToggleIcon)
  }));
};
OptionsMenuToggle.propTypes = {
  parentId: _pt.string,
  onToggle: _pt.func,
  isOpen: _pt.bool,
  isPlain: _pt.bool,
  isFocused: _pt.bool,
  isHovered: _pt.bool,
  isActive: _pt.bool,
  isDisabled: _pt.bool,
  hideCaret: _pt.bool,
  'aria-label': _pt.string,
  toggleTemplate: _pt.element
};
//# sourceMappingURL=OptionsMenuToggle.js.map