import _pt from "prop-types";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/OptionsMenu/options-menu';
import { css } from '@patternfly/react-styles';
import { fillTemplate } from '../../helpers';
import { DropdownToggle } from '../Dropdown';
export const OptionsToggle = ({
  itemsTitle = 'items',
  optionsToggle = 'Select',
  firstIndex = 0,
  lastIndex = 0,
  itemCount = 0,
  widgetId = '',
  showToggle = true,
  onToggle = _isOpen => undefined,
  isOpen = false,
  isDisabled = false,
  parentRef = null,
  toggleTemplate: ToggleTemplate = ''
}) => {
  return React.createElement("div", {
    className: css(styles.optionsMenuToggle, isDisabled && styles.modifiers.disabled, styles.modifiers.plain, styles.modifiers.text)
  }, showToggle && React.createElement(DropdownToggle, {
    "aria-label": optionsToggle,
    onToggle: onToggle,
    isDisabled: isDisabled || itemCount <= 0,
    isOpen: isOpen,
    id: `${widgetId}-toggle`,
    className: styles.optionsMenuToggleButton,
    parentRef: parentRef
  }, React.createElement("span", {
    className: css(styles.optionsMenuToggleText)
  }, typeof ToggleTemplate === 'string' ? fillTemplate(ToggleTemplate, {
    firstIndex,
    lastIndex,
    itemCount,
    itemsTitle
  }) : React.createElement(ToggleTemplate, {
    firstIndex: firstIndex,
    lastIndex: lastIndex,
    itemCount: itemCount,
    itemsTitle: itemsTitle
  }))));
};
OptionsToggle.propTypes = {
  itemsTitle: _pt.string,
  optionsToggle: _pt.string,
  firstIndex: _pt.number,
  lastIndex: _pt.number,
  itemCount: _pt.number,
  widgetId: _pt.string,
  showToggle: _pt.bool,
  onToggle: _pt.func,
  isOpen: _pt.bool,
  isDisabled: _pt.bool,
  parentRef: _pt.any,
  toggleTemplate: _pt.oneOfType([_pt.func, _pt.string])
};
//# sourceMappingURL=OptionsToggle.js.map