import _pt from "prop-types";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/OptionsMenu/options-menu';
import paginationStyles from '@patternfly/react-styles/css/components/Pagination/pagination';
import { css } from '@patternfly/react-styles';
import { Dropdown, DropdownItem, DropdownDirection } from '../Dropdown';
import { CheckIcon } from '@patternfly/react-icons';
import { OptionsToggle } from './OptionsToggle';
export class PaginationOptionsMenu extends React.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "parentRef", React.createRef());

    _defineProperty(this, "onToggle", isOpen => {
      this.setState({
        isOpen
      });
    });

    _defineProperty(this, "onSelect", () => {
      this.setState(prevState => {
        return {
          isOpen: !prevState.isOpen
        };
      });
    });

    _defineProperty(this, "renderItems", () => {
      const {
        perPageOptions,
        perPage,
        onPerPageSelect,
        perPageSuffix
      } = this.props;
      return perPageOptions.map(({
        value,
        title
      }) => React.createElement(DropdownItem, {
        key: value,
        component: "button",
        "data-action": `per-page-${value}`,
        className: css(styles.optionsMenuMenuItem, perPage === value && 'pf-m-selected'),
        onClick: event => onPerPageSelect(event, value)
      }, title, React.createElement("span", {
        className: css(paginationStyles.paginationMenuText)
      }, ` ${perPageSuffix}`), perPage === value && React.createElement("i", {
        className: css(styles.optionsMenuMenuItemIcon)
      }, React.createElement(CheckIcon, null))));
    });

    this.state = {
      isOpen: false
    };
  }

  render() {
    const {
      className,
      widgetId,
      isDisabled,
      itemsPerPageTitle,
      dropDirection,
      optionsToggle,
      perPageOptions,
      toggleTemplate,
      firstIndex,
      lastIndex,
      itemCount,
      itemsTitle
    } = this.props;
    const {
      isOpen
    } = this.state;
    return React.createElement("div", {
      className: css(styles.optionsMenu, className),
      ref: this.parentRef
    }, React.createElement("span", {
      id: `${widgetId}-label`,
      hidden: true
    }, itemsPerPageTitle, ":"), React.createElement(Dropdown, {
      direction: dropDirection,
      onSelect: this.onSelect,
      isOpen: isOpen,
      toggle: React.createElement(OptionsToggle, {
        optionsToggle: optionsToggle,
        showToggle: perPageOptions && perPageOptions.length > 0,
        onToggle: this.onToggle,
        isOpen: isOpen,
        widgetId: widgetId,
        firstIndex: firstIndex,
        lastIndex: lastIndex,
        itemCount: itemCount,
        itemsTitle: itemsTitle,
        toggleTemplate: toggleTemplate,
        parentRef: this.parentRef.current,
        isDisabled: isDisabled
      }),
      dropdownItems: this.renderItems(),
      isPlain: true
    }));
  }

}

_defineProperty(PaginationOptionsMenu, "propTypes", {
  className: _pt.string,
  widgetId: _pt.string,
  isDisabled: _pt.bool,
  dropDirection: _pt.oneOf(['up', 'down']),
  perPageOptions: _pt.arrayOf(_pt.any),
  itemsPerPageTitle: _pt.string,
  perPageSuffix: _pt.string,
  itemsTitle: _pt.string,
  optionsToggle: _pt.string,
  itemCount: _pt.number,
  firstIndex: _pt.number,
  lastIndex: _pt.number,
  perPage: _pt.number,
  toggleTemplate: _pt.oneOfType([_pt.func, _pt.string]),
  onPerPageSelect: _pt.func
});

_defineProperty(PaginationOptionsMenu, "defaultProps", {
  className: '',
  widgetId: '',
  isDisabled: false,
  dropDirection: DropdownDirection.down,
  perPageOptions: [],
  itemsPerPageTitle: 'Items per page',
  perPageSuffix: 'per page',
  optionsToggle: 'Select',
  perPage: 0,
  firstIndex: 0,
  lastIndex: 0,
  itemCount: 0,
  itemsTitle: 'items',
  toggleTemplate: ({
    firstIndex,
    lastIndex,
    itemCount,
    itemsTitle
  }) => React.createElement(React.Fragment, null, React.createElement("strong", null, firstIndex, " - ", lastIndex), ' ', "of", React.createElement("strong", null, itemCount), " ", itemsTitle),
  onPerPageSelect: () => null
});
//# sourceMappingURL=PaginationOptionsMenu.js.map