import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Button/button';
import { css, getModifier } from '@patternfly/react-styles';
export const Button = (_ref) => {
  let {
    children = null,
    className = '',
    component = 'button',
    isActive = false,
    isBlock = false,
    isDisabled = false,
    isFocus = false,
    isHover = false,
    isInline = false,
    type = 'button',
    variant = 'primary',
    'aria-label': ariaLabel = null,
    icon = null,
    render = true
  } = _ref,
      props = _objectWithoutProperties(_ref, ["children", "className", "component", "isActive", "isBlock", "isDisabled", "isFocus", "isHover", "isInline", "type", "variant", "aria-label", "icon", "render"]);

  if (!render) {
    return React.createElement("p", null, "no render");
  }

  const Component = component;
  const isButtonElement = Component === 'button';
  return React.createElement(Component, _extends({}, props, {
    "aria-disabled": isButtonElement ? null : isDisabled,
    "aria-label": ariaLabel,
    className: css(styles.button, getModifier(styles.modifiers, variant), isBlock && styles.modifiers.block, isDisabled && styles.modifiers.disabled, isActive && styles.modifiers.active, isFocus && styles.modifiers.focus, isHover && styles.modifiers.hover, isInline && variant === 'link' && styles.modifiers.inline, className),
    disabled: isButtonElement ? isDisabled : null,
    tabIndex: isDisabled && !isButtonElement ? -1 : null,
    type: isButtonElement ? type : null
  }), icon && variant === 'link' && React.createElement("span", {
    className: "pf-c-button__icon"
  }, icon), children);
};
Button.propTypes = {
  render: _pt.bool
};
//# sourceMappingURL=Button.js.map