"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApplicationLauncherItem = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _reactStyles = require("@patternfly/react-styles");

var _appLauncher = _interopRequireDefault(require("@patternfly/react-styles/css/components/AppLauncher/app-launcher"));

var _accessibility = _interopRequireDefault(require("@patternfly/react-styles/css/utilities/Accessibility/accessibility"));

var _Dropdown = require("../Dropdown");

var _InternalApplicationLauncherIcon = require("./InternalApplicationLauncherIcon");

var _InternalApplicationLauncherText = require("./InternalApplicationLauncherText");

var _reactIcons = require("@patternfly/react-icons");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var ApplicationLauncherItem = function ApplicationLauncherItem(_ref) {
  var _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      children = _ref.children,
      _ref$icon = _ref.icon,
      icon = _ref$icon === void 0 ? null : _ref$icon,
      _ref$isExternal = _ref.isExternal,
      isExternal = _ref$isExternal === void 0 ? false : _ref$isExternal,
      href = _ref.href,
      _ref$tooltip = _ref.tooltip,
      tooltip = _ref$tooltip === void 0 ? null : _ref$tooltip,
      _ref$tooltipProps = _ref.tooltipProps,
      tooltipProps = _ref$tooltipProps === void 0 ? null : _ref$tooltipProps,
      props = _objectWithoutProperties(_ref, ["className", "children", "icon", "isExternal", "href", "tooltip", "tooltipProps"]);

  return React.createElement(_Dropdown.DropdownItem, _extends({
    component: href ? 'a' : 'div',
    href: href || null,
    className: (0, _reactStyles.css)(isExternal && _appLauncher["default"].modifiers.external, className) // add style until https://github.com/patternfly/patternfly-next/issues/1944 is fixed
    ,
    style: !href ? {
      cursor: 'pointer'
    } : null,
    tooltip: tooltip,
    tooltipProps: tooltipProps
  }, props), icon && React.createElement(_InternalApplicationLauncherIcon.ApplicationLauncherIcon, null, icon), icon ? React.createElement(_InternalApplicationLauncherText.ApplicationLauncherText, null, children) : children, isExternal && React.createElement(React.Fragment, null, React.createElement("span", {
    className: (0, _reactStyles.css)(_appLauncher["default"].appLauncherMenuItemExternalIcon)
  }, React.createElement(_reactIcons.ExternalLinkAltIcon, null)), React.createElement("span", {
    className: (0, _reactStyles.css)(_accessibility["default"].screenReader)
  }, "(opens new window)")));
};

exports.ApplicationLauncherItem = ApplicationLauncherItem;
ApplicationLauncherItem.propTypes = {
  icon: _propTypes["default"].node,
  isExternal: _propTypes["default"].bool,
  tooltip: _propTypes["default"].node,
  tooltipProps: _propTypes["default"].any
};
//# sourceMappingURL=ApplicationLauncherItem.js.map