import * as React from 'react';
export declare const ChipGroupContext: React.Context<string>;
export interface ChipGroupProps extends React.HTMLProps<HTMLDivElement> {
    /** Content rendered inside the chip text */
    children?: React.ReactNode;
    /** Additional classes added to the chip item */
    className?: string;
    /** Customizable "Show Less" text string */
    expandedText?: string;
    /** Customizeable template string. Use variable "${remaining}" for the overflow chip count. */
    collapsedText?: string;
    /** Flag for grouping with a toolbar & category name */
    withToolbar?: boolean;
    /** Set heading level to the chip item label */
    headingLevel?: 'h1' | 'h2' | 'h3' | 'h4' | 'h5' | 'h6';
}
interface ChipGroupState {
    isOpen: boolean;
}
export declare class ChipGroup extends React.Component<ChipGroupProps, ChipGroupState> {
    constructor(props: ChipGroupProps);
    static defaultProps: {
        className: string;
        expandedText: string;
        collapsedText: string;
        withToolbar: boolean;
    };
    toggleCollapse: () => void;
    renderToolbarGroup(): JSX.Element;
    renderChipGroup(): JSX.Element;
    render(): JSX.Element;
}
export {};
