/// <reference types="node" />
import * as React from 'react';
import { OneOf, Omit } from '../../helpers/typeUtils';
import { PopoverPosition } from '../Popover';
import { TooltipPosition } from '../Tooltip';
export declare const clipboardCopyFunc: (event: any, text: string) => void;
export declare enum ClipboardCopyVariant {
    inline = "inline",
    expansion = "expansion"
}
export interface ClipboardCopyState {
    text: string | number;
    expanded: boolean;
    copied: boolean;
}
export interface ClipboardCopyProps extends Omit<React.HTMLProps<HTMLDivElement>, 'onChange'> {
    /** Additional classes added to the clipboard copy container. */
    className?: string;
    /** Tooltip message to display when hover the copy button */
    hoverTip?: string;
    /** Tooltip message to display when clicking the copy button */
    clickTip?: string;
    /** Custom flag to show that the input requires an associated id or aria-label. */
    textAriaLabel?: string;
    /** Custom flag to show that the toggle button requires an associated id or aria-label. */
    toggleAriaLabel?: string;
    /** Flag to show if the input is read only. */
    isReadOnly?: boolean;
    /** Adds Clipboard Copy variant styles. */
    variant?: typeof ClipboardCopyVariant | 'inline' | 'expansion';
    /** Copy button popover position. */
    position?: OneOf<typeof PopoverPosition, keyof typeof PopoverPosition>;
    /** Maximum width of the tooltip (default 150px). */
    maxWidth?: string;
    /** Delay in ms before the tooltip disappears. */
    exitDelay?: number;
    /** Delay in ms before the tooltip appears. */
    entryDelay?: number;
    /** Delay in ms before the tooltip message switch to hover tip. */
    switchDelay?: number;
    /** A function that is triggered on clicking the copy button. */
    onCopy?: (event: React.ClipboardEvent<HTMLDivElement>, text?: React.ReactNode) => void;
    /** A function that is triggered on changing the text. */
    onChange?: (text?: string | number) => void;
    /** The text which is copied. */
    children?: React.ReactNode;
}
export declare class ClipboardCopy extends React.Component<ClipboardCopyProps, ClipboardCopyState> {
    timer: NodeJS.Timer;
    constructor(props: ClipboardCopyProps);
    static defaultProps: {
        hoverTip: string;
        clickTip: string;
        isReadOnly: boolean;
        variant: string;
        position: TooltipPosition;
        maxWidth: string;
        exitDelay: number;
        entryDelay: number;
        switchDelay: number;
        onCopy: (event: any, text: string) => void;
        onChange: () => any;
        textAriaLabel: string;
        toggleAriaLabel: string;
    };
    expandContent: (_event: React.MouseEvent<Element, MouseEvent>) => void;
    updateText: (text: React.ReactText) => void;
    render: () => JSX.Element;
}
