"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropdownMenu = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var ReactDOM = _interopRequireWildcard(require("react-dom"));

var _dropdown = _interopRequireDefault(require("@patternfly/react-styles/css/components/Dropdown/dropdown"));

var _reactStyles = require("@patternfly/react-styles");

var _util = require("../../helpers/util");

var _dropdownConstants = require("./dropdownConstants");

var _constants = require("../../helpers/constants");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DropdownMenu =
/*#__PURE__*/
function (_React$Component) {
  _inherits(DropdownMenu, _React$Component);

  function DropdownMenu() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, DropdownMenu);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(DropdownMenu)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "refsCollection", []);

    _defineProperty(_assertThisInitialized(_this), "childKeyHandler", function (index, position) {
      var custom = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      (0, _util.keyHandler)(index, position, _this.refsCollection, _this.props.isGrouped ? _this.refsCollection : React.Children.toArray(_this.props.children), custom);
    });

    _defineProperty(_assertThisInitialized(_this), "sendRef", function (index, node, isDisabled) {
      if (!node.getAttribute) {
        // eslint-disable-line react/no-find-dom-node
        _this.refsCollection[index] = {
          current: ReactDOM.findDOMNode(node)
        };
      } else if (isDisabled || node.getAttribute('role') === 'separator') {
        _this.refsCollection[index] = null;
      } else {
        _this.refsCollection[index] = node;
      }
    });

    return _this;
  }

  _createClass(DropdownMenu, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var autoFocus = this.props.autoFocus;

      if (this.props.component === 'ul' && autoFocus) {
        var focusTarget = this.refsCollection.find(function (ref) {
          return ref && ref.current && !ref.current.hasAttribute('disabled');
        });

        if (focusTarget && focusTarget.current) {
          if (focusTarget.current.focus) {
            focusTarget.current.focus();
          } else {
            var searchedFocusTarget = ReactDOM.findDOMNode(focusTarget.current);
            searchedFocusTarget.focus();
          }
        } else if (focusTarget) {
          ; // eslint-disable-line react/no-find-dom-node
        }
      }
    }
  }, {
    key: "extendChildren",
    value: function extendChildren() {
      var _this$props = this.props,
          children = _this$props.children,
          isGrouped = _this$props.isGrouped;

      if (isGrouped) {
        var index = 0;
        return React.Children.map(children, function (groupedChildren) {
          var group = groupedChildren;
          return React.cloneElement(group, {
            children: group.props.children.constructor === Array && React.Children.map(group.props.children, function (option) {
              return React.cloneElement(option, {
                index: index++
              });
            }) || React.cloneElement(group.props.children, {
              index: index++
            })
          });
        });
      }

      return React.Children.map(children, function (child, index) {
        return React.cloneElement(child, {
          index: index
        });
      });
    }
  }, {
    key: "extendCustomChildren",
    value: function extendCustomChildren() {
      var _this2 = this;

      var mappedChildren = React.Children.map(this.props.children, function (child0, index) {
        var child = child0;
        var mappedChild = React.cloneElement(child, {
          ref: React.createRef(),
          className: "".concat((0, _reactStyles.css)(child.props.isDisabled && _dropdown["default"].modifiers.disabled, child.props.isHovered && _dropdown["default"].modifiers.hover, _dropdown["default"].dropdownMenuItem)).concat(child.props.className ? child.props.className : ''),
          tabIndex: -1,
          onKeyDown: function onKeyDown(event) {
            if (event.keyCode === _constants.KEY_CODES.TAB) {
              return;
            }

            ;
            event.preventDefault();

            if (event.keyCode === _constants.KEY_CODES.ARROW_UP) {
              (0, _util.keyHandler)(index, _constants.KEYHANDLER_DIRECTION.UP, _this2.refsCollection, React.Children.toArray(_this2.props.children), true);
            } else if (event.keyCode === _constants.KEY_CODES.ARROW_DOWN) {
              (0, _util.keyHandler)(index, _constants.KEYHANDLER_DIRECTION.DOWN, _this2.refsCollection, React.Children.toArray(_this2.props.children), true);
            }
          }
        });
        !mappedChild.props.disabled ? _this2.refsCollection[index] = mappedChild.props.ref : _this2.refsCollection[index] = null;
        return mappedChild;
      });
      return mappedChildren;
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props2 = this.props,
          className = _this$props2.className,
          isOpen = _this$props2.isOpen,
          position = _this$props2.position,
          children = _this$props2.children,
          component = _this$props2.component,
          isGrouped = _this$props2.isGrouped,
          openedOnEnter = _this$props2.openedOnEnter,
          props = _objectWithoutProperties(_this$props2, ["className", "isOpen", "position", "children", "component", "isGrouped", "openedOnEnter"]);

      var Component = component;
      return React.createElement(_dropdownConstants.DropdownArrowContext.Provider, {
        value: {
          keyHandler: this.childKeyHandler,
          sendRef: this.sendRef
        }
      }, Component === 'div' ? React.createElement(_dropdownConstants.DropdownContext.Consumer, null, function (_ref) {
        var onSelect = _ref.onSelect,
            menuClass = _ref.menuClass;
        return React.createElement("ul", {
          className: (0, _reactStyles.css)(menuClass, position === _dropdownConstants.DropdownPosition.right && _dropdown["default"].modifiers.alignRight, className),
          hidden: !isOpen,
          onClick: function onClick(event) {
            return onSelect && onSelect(event);
          }
        }, React.createElement(Component, props, _this3.extendCustomChildren()));
      }) : isGrouped && React.createElement(_dropdownConstants.DropdownContext.Consumer, null, function (_ref2) {
        var menuClass = _ref2.menuClass;
        return React.createElement("div", _extends({}, props, {
          className: (0, _reactStyles.css)(menuClass, position === _dropdownConstants.DropdownPosition.right && _dropdown["default"].modifiers.alignRight, className),
          hidden: !isOpen,
          role: "menu"
        }), _this3.extendChildren());
      }) || React.createElement(_dropdownConstants.DropdownContext.Consumer, null, function (_ref3) {
        var menuClass = _ref3.menuClass;
        return React.createElement(Component, _extends({}, props, {
          className: (0, _reactStyles.css)(menuClass, position === _dropdownConstants.DropdownPosition.right && _dropdown["default"].modifiers.alignRight, className),
          hidden: !isOpen,
          role: "menu"
        }), _this3.extendChildren());
      }));
    }
  }]);

  return DropdownMenu;
}(React.Component);

exports.DropdownMenu = DropdownMenu;

_defineProperty(DropdownMenu, "propTypes", {
  children: _propTypes["default"].node,
  className: _propTypes["default"].string,
  isOpen: _propTypes["default"].bool,
  openedOnEnter: _propTypes["default"].bool,
  autoFocus: _propTypes["default"].bool,
  component: _propTypes["default"].node,
  position: _propTypes["default"].oneOfType([_propTypes["default"].any, _propTypes["default"].oneOf(['right']), _propTypes["default"].oneOf(['left'])]),
  isGrouped: _propTypes["default"].bool
});

_defineProperty(DropdownMenu, "defaultProps", {
  className: '',
  isOpen: true,
  openedOnEnter: false,
  autoFocus: true,
  position: _dropdownConstants.DropdownPosition.left,
  component: 'ul',
  isGrouped: false
});
//# sourceMappingURL=DropdownMenu.js.map