import * as React from 'react';
export interface OptionsMenuToggleProps extends React.HTMLProps<HTMLButtonElement> {
    /** Id of the parent Options menu component */
    parentId?: string;
    /** Callback for when this Options menu is toggled */
    onToggle?: (event: React.MouseEvent<HTMLButtonElement>) => void;
    /** Flag to indicate if menu is open */
    isOpen?: boolean;
    /** Flag to indicate if the button is plain */
    isPlain?: boolean;
    /** Forces display of the hover state of the Options menu */
    isFocused?: boolean;
    /** Forces display of the hover state of the Options menu */
    isHovered?: boolean;
    /** Forces display of the active state of the Options menu */
    isActive?: boolean;
    /** Disables the options menu toggle */
    isDisabled?: boolean;
    /** hide the toggle caret */
    hideCaret?: boolean;
    /** Provides an accessible name for the button when an icon is used instead of text */
    'aria-label'?: string;
    /** Content to be rendered in the Options menu toggle button */
    toggleTemplate?: React.ReactElement<any>;
}
export declare const OptionsMenuToggle: React.FunctionComponent<OptionsMenuToggleProps>;
