"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsToggle = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _optionsMenu = _interopRequireDefault(require("@patternfly/react-styles/css/components/OptionsMenu/options-menu"));

var _reactStyles = require("@patternfly/react-styles");

var _helpers = require("../../helpers");

var _Dropdown = require("../Dropdown");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var OptionsToggle = function OptionsToggle(_ref) {
  var _ref$itemsTitle = _ref.itemsTitle,
      itemsTitle = _ref$itemsTitle === void 0 ? 'items' : _ref$itemsTitle,
      _ref$optionsToggle = _ref.optionsToggle,
      optionsToggle = _ref$optionsToggle === void 0 ? 'Select' : _ref$optionsToggle,
      _ref$firstIndex = _ref.firstIndex,
      firstIndex = _ref$firstIndex === void 0 ? 0 : _ref$firstIndex,
      _ref$lastIndex = _ref.lastIndex,
      lastIndex = _ref$lastIndex === void 0 ? 0 : _ref$lastIndex,
      _ref$itemCount = _ref.itemCount,
      itemCount = _ref$itemCount === void 0 ? 0 : _ref$itemCount,
      _ref$widgetId = _ref.widgetId,
      widgetId = _ref$widgetId === void 0 ? '' : _ref$widgetId,
      _ref$showToggle = _ref.showToggle,
      showToggle = _ref$showToggle === void 0 ? true : _ref$showToggle,
      _ref$onToggle = _ref.onToggle,
      onToggle = _ref$onToggle === void 0 ? function (_isOpen) {
    return undefined;
  } : _ref$onToggle,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      _ref$parentRef = _ref.parentRef,
      parentRef = _ref$parentRef === void 0 ? null : _ref$parentRef,
      _ref$toggleTemplate = _ref.toggleTemplate,
      ToggleTemplate = _ref$toggleTemplate === void 0 ? '' : _ref$toggleTemplate;
  return React.createElement("div", {
    className: (0, _reactStyles.css)(_optionsMenu["default"].optionsMenuToggle, isDisabled && _optionsMenu["default"].modifiers.disabled, _optionsMenu["default"].modifiers.plain, _optionsMenu["default"].modifiers.text)
  }, showToggle && React.createElement(_Dropdown.DropdownToggle, {
    "aria-label": optionsToggle,
    onToggle: onToggle,
    isDisabled: isDisabled || itemCount <= 0,
    isOpen: isOpen,
    id: "".concat(widgetId, "-toggle"),
    className: _optionsMenu["default"].optionsMenuToggleButton,
    parentRef: parentRef
  }, React.createElement("span", {
    className: (0, _reactStyles.css)(_optionsMenu["default"].optionsMenuToggleText)
  }, typeof ToggleTemplate === 'string' ? (0, _helpers.fillTemplate)(ToggleTemplate, {
    firstIndex: firstIndex,
    lastIndex: lastIndex,
    itemCount: itemCount,
    itemsTitle: itemsTitle
  }) : React.createElement(ToggleTemplate, {
    firstIndex: firstIndex,
    lastIndex: lastIndex,
    itemCount: itemCount,
    itemsTitle: itemsTitle
  }))));
};

exports.OptionsToggle = OptionsToggle;
OptionsToggle.propTypes = {
  itemsTitle: _propTypes["default"].string,
  optionsToggle: _propTypes["default"].string,
  firstIndex: _propTypes["default"].number,
  lastIndex: _propTypes["default"].number,
  itemCount: _propTypes["default"].number,
  widgetId: _propTypes["default"].string,
  showToggle: _propTypes["default"].bool,
  onToggle: _propTypes["default"].func,
  isOpen: _propTypes["default"].bool,
  isDisabled: _propTypes["default"].bool,
  parentRef: _propTypes["default"].any,
  toggleTemplate: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].string])
};
//# sourceMappingURL=OptionsToggle.js.map