import * as React from 'react';
import { ToggleTemplateProps } from './ToggleTemplate';
export declare enum PaginationVariant {
    top = "top",
    bottom = "bottom",
    left = "left",
    right = "right"
}
export interface PerPageOptions {
    title?: string;
    value?: number;
}
export interface PaginationTitles {
    page?: string;
    items?: string;
    itemsPerPage?: string;
    perPageSuffix?: string;
    toFirstPage?: string;
    toPreviousPage?: string;
    toLastPage?: string;
    toNextPage?: string;
    optionsToggle?: string;
    currPage?: string;
    paginationTitle?: string;
}
export interface PaginationProps extends React.HTMLProps<HTMLDivElement> {
    /** What should be rendered inside */
    children?: React.ReactNode;
    /** Additional classes for the container. */
    className?: string;
    /** Total number of items. */
    itemCount: number;
    /** Position where pagination is rendered. */
    variant?: 'top' | 'bottom' | 'left' | 'right';
    /** Flag indicating if pagination is disabled */
    isDisabled?: boolean;
    /** Number of items per page. */
    perPage?: number;
    /** Select from options to number of items per page. */
    perPageOptions?: PerPageOptions[];
    /** Page we start at. */
    firstPage?: number;
    /** Current page number. */
    page?: number;
    /** First index of items on current page. */
    itemsStart?: number;
    /** Last index of items on current page. */
    itemsEnd?: number;
    /** ID to ideintify widget on page. */
    widgetId?: string;
    /** Direction of dropdown context menu. */
    dropDirection?: 'up' | 'down';
    /** Object with titles to display in pagination. */
    titles?: PaginationTitles;
    /** This will be shown in pagination toggle span. You can use firstIndex, lastIndex, itemCount, itemsTitle props. */
    toggleTemplate?: ((props: ToggleTemplateProps) => React.ReactElement) | string;
    /** Function called when user sets page. */
    onSetPage?: (event: React.SyntheticEvent<HTMLButtonElement>, page: number) => void;
    /** Function called when user clicks on navigate to first page. */
    onFirstClick?: (event: React.SyntheticEvent<HTMLButtonElement>, page: number) => void;
    /** Function called when user clicks on navigate to previous page. */
    onPreviousClick?: (event: React.SyntheticEvent<HTMLButtonElement>, page: number) => void;
    /** Function called when user clicks on navigate to next page. */
    onNextClick?: (event: React.SyntheticEvent<HTMLButtonElement>, page: number) => void;
    /** Function called when user clicks on navigate to last page. */
    onLastClick?: (event: React.SyntheticEvent<HTMLButtonElement>, page: number) => void;
    /** Function called when user inputs page number. */
    onPageInput?: (event: React.SyntheticEvent<HTMLButtonElement>, page: number) => void;
    /** Function called when user selects number of items per page. */
    onPerPageSelect?: (event: React.MouseEvent | React.KeyboardEvent | MouseEvent, perPage: number) => void;
}
export declare const Pagination: React.FunctionComponent<PaginationProps>;
