(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles", "@patternfly/react-styles/css/components/AppLauncher/app-launcher", "@patternfly/react-styles/css/utilities/Accessibility/accessibility", "../Dropdown", "./InternalApplicationLauncherIcon", "./InternalApplicationLauncherText", "@patternfly/react-icons"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles"), require("@patternfly/react-styles/css/components/AppLauncher/app-launcher"), require("@patternfly/react-styles/css/utilities/Accessibility/accessibility"), require("../Dropdown"), require("./InternalApplicationLauncherIcon"), require("./InternalApplicationLauncherText"), require("@patternfly/react-icons"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactStyles, global.appLauncher, global.accessibility, global.Dropdown, global.InternalApplicationLauncherIcon, global.InternalApplicationLauncherText, global.reactIcons);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _reactStyles, _appLauncher, _accessibility, _Dropdown, _InternalApplicationLauncherIcon, _InternalApplicationLauncherText, _reactIcons) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ApplicationLauncherItem = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _appLauncher2 = _interopRequireDefault(_appLauncher);

  var _accessibility2 = _interopRequireDefault(_accessibility);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  const ApplicationLauncherItem = exports.ApplicationLauncherItem = _ref => {
    let {
      className = '',
      children,
      icon = null,
      isExternal = false,
      href,
      tooltip = null,
      tooltipProps = null
    } = _ref,
        props = _objectWithoutProperties(_ref, ["className", "children", "icon", "isExternal", "href", "tooltip", "tooltipProps"]);

    return React.createElement(_Dropdown.DropdownItem, _extends({
      component: href ? 'a' : 'div',
      href: href || null,
      className: (0, _reactStyles.css)(isExternal && _appLauncher2.default.modifiers.external, className) // add style until https://github.com/patternfly/patternfly-next/issues/1944 is fixed
      ,
      style: !href ? {
        cursor: 'pointer'
      } : null,
      tooltip: tooltip,
      tooltipProps: tooltipProps
    }, props), icon && React.createElement(_InternalApplicationLauncherIcon.ApplicationLauncherIcon, null, icon), icon ? React.createElement(_InternalApplicationLauncherText.ApplicationLauncherText, null, children) : children, isExternal && React.createElement(React.Fragment, null, React.createElement("span", {
      className: (0, _reactStyles.css)(_appLauncher2.default.appLauncherMenuItemExternalIcon)
    }, React.createElement(_reactIcons.ExternalLinkAltIcon, null)), React.createElement("span", {
      className: (0, _reactStyles.css)(_accessibility2.default.screenReader)
    }, "(opens new window)")));
  };

  ApplicationLauncherItem.propTypes = {
    icon: _propTypes2.default.node,
    isExternal: _propTypes2.default.bool,
    tooltip: _propTypes2.default.node,
    tooltipProps: _propTypes2.default.any
  };
});
//# sourceMappingURL=ApplicationLauncherItem.js.map