(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles/css/components/Dropdown/dropdown", "@patternfly/react-styles", "./DropdownMenu", "./dropdownConstants"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles/css/components/Dropdown/dropdown"), require("@patternfly/react-styles"), require("./DropdownMenu"), require("./dropdownConstants"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.dropdown, global.reactStyles, global.DropdownMenu, global.dropdownConstants);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _dropdown, _reactStyles, _DropdownMenu, _dropdownConstants) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Dropdown = exports.DropdownWithContext = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _dropdown2 = _interopRequireDefault(_dropdown);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  class DropdownWithContext extends React.Component {
    // seed for the aria-labelledby ID
    constructor(props) {
      super(props);

      _defineProperty(this, "openedOnEnter", false);

      _defineProperty(this, "baseComponentRef", React.createRef());

      _defineProperty(this, "onEnter", () => {
        this.openedOnEnter = true;
      });

      if (props.dropdownItems && props.dropdownItems.length > 0 && props.children) {
        throw new Error(`Children and dropdownItems props have been provided. Only the dropdownItems prop items will be rendered `);
      }
    }

    componentDidUpdate() {
      if (!this.props.isOpen) {
        this.openedOnEnter = false;
      }
    }

    render() {
      const _this$props = this.props,
            {
        children,
        className,
        direction,
        dropdownItems,
        isOpen,
        isPlain,
        isGrouped,
        onSelect,
        position,
        toggle
      } = _this$props,
            props = _objectWithoutProperties(_this$props, ["children", "className", "direction", "dropdownItems", "isOpen", "isPlain", "isGrouped", "onSelect", "position", "toggle"]);

      const id = toggle.props.id || `pf-toggle-id-${DropdownWithContext.currentId++}`;
      let component;
      let renderedContent;
      let ariaHasPopup = false;

      if (dropdownItems && dropdownItems.length > 0) {
        component = 'ul';
        renderedContent = dropdownItems;
        ariaHasPopup = true;
      } else {
        component = 'div';
        renderedContent = React.Children.toArray(children);
      }

      return React.createElement(_dropdownConstants.DropdownContext.Consumer, null, ({
        baseClass,
        baseComponent
      }) => {
        const BaseComponent = baseComponent;
        return React.createElement(BaseComponent, _extends({}, props, {
          className: (0, _reactStyles.css)(baseClass, direction === _dropdownConstants.DropdownDirection.up && _dropdown2.default.modifiers.top, isOpen && _dropdown2.default.modifiers.expanded, className),
          ref: this.baseComponentRef
        }), React.Children.map(toggle, oneToggle => React.cloneElement(oneToggle, {
          parentRef: this.baseComponentRef,
          isOpen,
          id,
          isPlain,
          ariaHasPopup,
          onEnter: this.onEnter
        })), isOpen && React.createElement(_DropdownMenu.DropdownMenu, {
          component: component,
          isOpen: isOpen,
          position: position,
          "aria-labelledby": id,
          openedOnEnter: this.openedOnEnter,
          isGrouped: isGrouped
        }, renderedContent));
      });
    }

  }

  exports.DropdownWithContext = DropdownWithContext;

  _defineProperty(DropdownWithContext, "propTypes", {
    children: _propTypes2.default.node,
    className: _propTypes2.default.string,
    dropdownItems: _propTypes2.default.arrayOf(_propTypes2.default.any),
    isOpen: _propTypes2.default.bool,
    isPlain: _propTypes2.default.bool,
    position: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.oneOf(['right']), _propTypes2.default.oneOf(['left'])]),
    direction: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.oneOf(['up']), _propTypes2.default.oneOf(['down'])]),
    isGrouped: _propTypes2.default.bool,
    toggle: _propTypes2.default.element.isRequired
  });

  _defineProperty(DropdownWithContext, "currentId", 0);

  _defineProperty(DropdownWithContext, "defaultProps", {
    className: '',
    dropdownItems: [],
    isOpen: false,
    isPlain: false,
    isGrouped: false,
    position: _dropdownConstants.DropdownPosition.left,
    direction: _dropdownConstants.DropdownDirection.down,
    onSelect: Function.prototype
  });

  const Dropdown = exports.Dropdown = _ref => {
    let {
      onSelect,
      ref
    } = _ref,
        props = _objectWithoutProperties(_ref, ["onSelect", "ref"]);

    return React.createElement(_dropdownConstants.DropdownContext.Provider, {
      value: {
        onSelect: event => onSelect && onSelect(event),
        menuClass: _dropdown2.default.dropdownMenu,
        itemClass: _dropdown2.default.dropdownMenuItem,
        toggleClass: _dropdown2.default.dropdownToggle,
        baseClass: _dropdown2.default.dropdown,
        baseComponent: 'div',
        sectionClass: _dropdown2.default.dropdownGroup,
        sectionTitleClass: _dropdown2.default.dropdownGroupTitle,
        sectionComponent: 'section',
        disabledClass: _dropdown2.default.modifiers.disabled,
        hoverClass: _dropdown2.default.modifiers.hover,
        separatorClass: _dropdown2.default.dropdownSeparator
      }
    }, React.createElement(DropdownWithContext, props));
  };

  Dropdown.propTypes = {
    children: _propTypes2.default.node,
    className: _propTypes2.default.string,
    dropdownItems: _propTypes2.default.arrayOf(_propTypes2.default.any),
    isOpen: _propTypes2.default.bool,
    isPlain: _propTypes2.default.bool,
    position: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.oneOf(['right']), _propTypes2.default.oneOf(['left'])]),
    direction: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.oneOf(['up']), _propTypes2.default.oneOf(['down'])]),
    isGrouped: _propTypes2.default.bool,
    toggle: _propTypes2.default.element.isRequired
  };
});
//# sourceMappingURL=Dropdown.js.map