(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "react-dom", "@patternfly/react-styles/css/components/Dropdown/dropdown", "@patternfly/react-styles", "../../helpers/util", "./dropdownConstants", "../../helpers/constants"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("react-dom"), require("@patternfly/react-styles/css/components/Dropdown/dropdown"), require("@patternfly/react-styles"), require("../../helpers/util"), require("./dropdownConstants"), require("../../helpers/constants"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactDom, global.dropdown, global.reactStyles, global.util, global.dropdownConstants, global.constants);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _reactDom, _dropdown, _reactStyles, _util, _dropdownConstants, _constants) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.DropdownMenu = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var ReactDOM = _interopRequireWildcard(_reactDom);

  var _dropdown2 = _interopRequireDefault(_dropdown);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  class DropdownMenu extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "refsCollection", []);

      _defineProperty(this, "childKeyHandler", (index, position, custom = false) => {
        (0, _util.keyHandler)(index, position, this.refsCollection, this.props.isGrouped ? this.refsCollection : React.Children.toArray(this.props.children), custom);
      });

      _defineProperty(this, "sendRef", (index, node, isDisabled) => {
        if (!node.getAttribute) {
          // eslint-disable-line react/no-find-dom-node
          this.refsCollection[index] = {
            current: ReactDOM.findDOMNode(node)
          };
        } else if (isDisabled || node.getAttribute('role') === 'separator') {
          this.refsCollection[index] = null;
        } else {
          this.refsCollection[index] = node;
        }
      });
    }

    componentDidMount() {
      const {
        autoFocus
      } = this.props;

      if (this.props.component === 'ul' && autoFocus) {
        const focusTarget = this.refsCollection.find(ref => ref && ref.current && !ref.current.hasAttribute('disabled'));

        if (focusTarget && focusTarget.current) {
          if (focusTarget.current.focus) {
            focusTarget.current.focus();
          } else {
            const searchedFocusTarget = ReactDOM.findDOMNode(focusTarget.current);
            searchedFocusTarget.focus();
          }
        } else if (focusTarget) {
          ; // eslint-disable-line react/no-find-dom-node
        }
      }
    }

    extendChildren() {
      const {
        children,
        isGrouped
      } = this.props;

      if (isGrouped) {
        let index = 0;
        return React.Children.map(children, groupedChildren => {
          const group = groupedChildren;
          return React.cloneElement(group, {
            children: group.props.children.constructor === Array && React.Children.map(group.props.children, option => React.cloneElement(option, {
              index: index++
            })) || React.cloneElement(group.props.children, {
              index: index++
            })
          });
        });
      }

      return React.Children.map(children, (child, index) => React.cloneElement(child, {
        index
      }));
    }

    extendCustomChildren() {
      const mappedChildren = React.Children.map(this.props.children, (child0, index) => {
        const child = child0;
        const mappedChild = React.cloneElement(child, {
          ref: React.createRef(),
          className: `${(0, _reactStyles.css)(child.props.isDisabled && _dropdown2.default.modifiers.disabled, child.props.isHovered && _dropdown2.default.modifiers.hover, _dropdown2.default.dropdownMenuItem)}${child.props.className ? child.props.className : ''}`,
          tabIndex: -1,
          onKeyDown: event => {
            if (event.keyCode === _constants.KEY_CODES.TAB) {
              return;
            }

            ;
            event.preventDefault();

            if (event.keyCode === _constants.KEY_CODES.ARROW_UP) {
              (0, _util.keyHandler)(index, _constants.KEYHANDLER_DIRECTION.UP, this.refsCollection, React.Children.toArray(this.props.children), true);
            } else if (event.keyCode === _constants.KEY_CODES.ARROW_DOWN) {
              (0, _util.keyHandler)(index, _constants.KEYHANDLER_DIRECTION.DOWN, this.refsCollection, React.Children.toArray(this.props.children), true);
            }
          }
        });
        !mappedChild.props.disabled ? this.refsCollection[index] = mappedChild.props.ref : this.refsCollection[index] = null;
        return mappedChild;
      });
      return mappedChildren;
    }

    render() {
      const _this$props = this.props,
            {
        className,
        isOpen,
        position,
        children,
        component,
        isGrouped,
        openedOnEnter
      } = _this$props,
            props = _objectWithoutProperties(_this$props, ["className", "isOpen", "position", "children", "component", "isGrouped", "openedOnEnter"]);

      const Component = component;
      return React.createElement(_dropdownConstants.DropdownArrowContext.Provider, {
        value: {
          keyHandler: this.childKeyHandler,
          sendRef: this.sendRef
        }
      }, Component === 'div' ? React.createElement(_dropdownConstants.DropdownContext.Consumer, null, ({
        onSelect,
        menuClass
      }) => React.createElement("ul", {
        className: (0, _reactStyles.css)(menuClass, position === _dropdownConstants.DropdownPosition.right && _dropdown2.default.modifiers.alignRight, className),
        hidden: !isOpen,
        onClick: event => onSelect && onSelect(event)
      }, React.createElement(Component, props, this.extendCustomChildren()))) : isGrouped && React.createElement(_dropdownConstants.DropdownContext.Consumer, null, ({
        menuClass
      }) => React.createElement("div", _extends({}, props, {
        className: (0, _reactStyles.css)(menuClass, position === _dropdownConstants.DropdownPosition.right && _dropdown2.default.modifiers.alignRight, className),
        hidden: !isOpen,
        role: "menu"
      }), this.extendChildren())) || React.createElement(_dropdownConstants.DropdownContext.Consumer, null, ({
        menuClass
      }) => React.createElement(Component, _extends({}, props, {
        className: (0, _reactStyles.css)(menuClass, position === _dropdownConstants.DropdownPosition.right && _dropdown2.default.modifiers.alignRight, className),
        hidden: !isOpen,
        role: "menu"
      }), this.extendChildren())));
    }

  }

  exports.DropdownMenu = DropdownMenu;

  _defineProperty(DropdownMenu, "propTypes", {
    children: _propTypes2.default.node,
    className: _propTypes2.default.string,
    isOpen: _propTypes2.default.bool,
    openedOnEnter: _propTypes2.default.bool,
    autoFocus: _propTypes2.default.bool,
    component: _propTypes2.default.node,
    position: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.oneOf(['right']), _propTypes2.default.oneOf(['left'])]),
    isGrouped: _propTypes2.default.bool
  });

  _defineProperty(DropdownMenu, "defaultProps", {
    className: '',
    isOpen: true,
    openedOnEnter: false,
    autoFocus: true,
    position: _dropdownConstants.DropdownPosition.left,
    component: 'ul',
    isGrouped: false
  });
});
//# sourceMappingURL=DropdownMenu.js.map