(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles", "./dropdownConstants", "../../helpers/constants", "../Tooltip"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles"), require("./dropdownConstants"), require("../../helpers/constants"), require("../Tooltip"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactStyles, global.dropdownConstants, global.constants, global.Tooltip);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _reactStyles, _dropdownConstants, _constants, _Tooltip) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.InternalDropdownItem = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  class InternalDropdownItem extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "ref", React.createRef());

      _defineProperty(this, "onKeyDown", event => {
        // Detected key press on this item, notify the menu parent so that the appropriate
        // item can be focused
        if (event.keyCode === _constants.KEY_CODES.TAB) {
          return;
        }

        ;
        event.preventDefault();

        if (event.keyCode === _constants.KEY_CODES.ARROW_UP) {
          this.props.context.keyHandler(this.props.index, _constants.KEYHANDLER_DIRECTION.UP);
        } else if (event.keyCode === _constants.KEY_CODES.ARROW_DOWN) {
          this.props.context.keyHandler(this.props.index, _constants.KEYHANDLER_DIRECTION.DOWN);
        } else if (event.keyCode === _constants.KEY_CODES.ENTER && this.ref.current && this.ref.current.click) {
          this.ref.current.click();
        }
      });
    }

    componentDidMount() {
      this.props.context.sendRef(this.props.index, this.ref.current, this.props.isDisabled);
    }

    render() {
      const _this$props = this.props,
            {
        className,
        children,
        isHovered,
        context,
        onClick,
        component,
        isDisabled,
        index,
        href,
        tooltip,
        tooltipProps
      } = _this$props,
            additionalProps = _objectWithoutProperties(_this$props, ["className", "children", "isHovered", "context", "onClick", "component", "isDisabled", "index", "href", "tooltip", "tooltipProps"]);

      const Component = component;
      let classes;

      if (Component === 'a') {
        additionalProps['aria-disabled'] = isDisabled;
        additionalProps.tabIndex = isDisabled ? -1 : additionalProps.tabIndex;
      } else if (Component === 'button') {
        additionalProps.disabled = isDisabled;
        additionalProps.type = additionalProps.type || 'button';
      }

      const renderWithTooltip = childNode => tooltip ? React.createElement(_Tooltip.Tooltip, _extends({
        content: tooltip
      }, tooltipProps), childNode) : childNode;

      return React.createElement(_dropdownConstants.DropdownContext.Consumer, null, ({
        onSelect,
        itemClass,
        disabledClass,
        hoverClass
      }) => {
        if (this.props.role === 'separator') {
          classes = className;
        } else {
          classes = (0, _reactStyles.css)(isDisabled && disabledClass, isHovered && hoverClass, className);
        }

        return React.createElement("li", {
          role: "none"
        }, React.isValidElement(children) ? React.Children.map(children, child => {
          const toClone = child;
          const clonedElement = React.cloneElement(toClone, {
            className: (0, _reactStyles.css)(classes, itemClass),
            ref: this.ref,
            onKeyDown: this.onKeyDown,
            onClick: event => {
              if (!isDisabled) {
                onClick(event);
                onSelect(event);
              }
            }
          });
          return renderWithTooltip(clonedElement);
        }) : renderWithTooltip(React.createElement(Component, _extends({}, additionalProps, {
          href: href || null,
          className: (0, _reactStyles.css)(classes, this.props.role !== 'separator' && itemClass),
          ref: this.ref,
          onKeyDown: this.onKeyDown,
          onClick: event => {
            if (!isDisabled) {
              onClick(event);
              onSelect(event);
            }
          }
        }), children)));
      });
    }

  }

  exports.InternalDropdownItem = InternalDropdownItem;

  _defineProperty(InternalDropdownItem, "propTypes", {
    children: _propTypes2.default.node,
    className: _propTypes2.default.string,
    component: _propTypes2.default.oneOfType([_propTypes2.default.node, _propTypes2.default.string]),
    role: _propTypes2.default.string,
    isDisabled: _propTypes2.default.bool,
    isHovered: _propTypes2.default.bool,
    href: _propTypes2.default.string,
    tooltip: _propTypes2.default.node,
    tooltipProps: _propTypes2.default.any,
    index: _propTypes2.default.number,
    context: _propTypes2.default.shape({
      keyHandler: _propTypes2.default.func,
      sendRef: _propTypes2.default.func
    }),
    onClick: _propTypes2.default.func
  });

  _defineProperty(InternalDropdownItem, "defaultProps", {
    className: '',
    isHovered: false,
    component: 'a',
    isDisabled: false,
    href: '',
    tooltipProps: {},
    onClick: event => undefined,
    onSelect: () => undefined,
    index: -1,
    context: {
      keyHandler: Function.prototype,
      sendRef: Function.prototype
    }
  });
});
//# sourceMappingURL=InternalDropdownItem.js.map