(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "react"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("react"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.react);
    global.undefined = mod.exports;
  }
})(this, function (exports, _react) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.DropdownArrowContext = exports.DropdownContext = exports.DropdownDirection = exports.DropdownPosition = undefined;

  var React = _interopRequireWildcard(_react);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  let DropdownPosition = exports.DropdownPosition = undefined;

  (function (DropdownPosition) {
    DropdownPosition["right"] = "right";
    DropdownPosition["left"] = "left";
  })(DropdownPosition || (exports.DropdownPosition = DropdownPosition = {}));

  ;
  let DropdownDirection = exports.DropdownDirection = undefined;

  (function (DropdownDirection) {
    DropdownDirection["up"] = "up";
    DropdownDirection["down"] = "down";
  })(DropdownDirection || (exports.DropdownDirection = DropdownDirection = {}));

  ;
  const DropdownContext = exports.DropdownContext = React.createContext({
    onSelect: event => undefined,
    menuClass: '',
    itemClass: '',
    toggleClass: '',
    baseClass: '',
    baseComponent: 'div',
    sectionClass: '',
    sectionTitleClass: '',
    sectionComponent: 'section',
    disabledClass: '',
    hoverClass: '',
    separatorClass: ''
  });
  const DropdownArrowContext = exports.DropdownArrowContext = React.createContext({
    keyHandler: null,
    sendRef: null
  });
});
//# sourceMappingURL=dropdownConstants.js.map