(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "react-dom", "exenv", "@patternfly/react-styles", "@patternfly/react-styles/css/components/Backdrop/backdrop", "../../helpers/constants", "./ModalContent"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("react-dom"), require("exenv"), require("@patternfly/react-styles"), require("@patternfly/react-styles/css/components/Backdrop/backdrop"), require("../../helpers/constants"), require("./ModalContent"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactDom, global.exenv, global.reactStyles, global.backdrop, global.constants, global.ModalContent);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _reactDom, _exenv, _reactStyles, _backdrop, _constants, _ModalContent) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Modal = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var ReactDOM = _interopRequireWildcard(_reactDom);

  var _backdrop2 = _interopRequireDefault(_backdrop);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  class Modal extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty(this, "id", '');

      _defineProperty(this, "handleEscKeyClick", event => {
        if (event.keyCode === _constants.KEY_CODES.ESCAPE_KEY && this.props.isOpen) {
          this.props.onClose();
        }
      });

      _defineProperty(this, "toggleSiblingsFromScreenReaders", hide => {
        const bodyChildren = document.body.children;

        for (const child of Array.from(bodyChildren)) {
          if (child !== this.state.container) {
            hide ? child.setAttribute('aria-hidden', '' + hide) : child.removeAttribute('aria-hidden');
          }
        }
      });

      const newId = Modal.currentId++;
      this.id = `pf-modal-${newId}`;
      this.state = {
        container: undefined
      };
    }

    componentDidMount() {
      const container = document.createElement('div');
      this.setState({
        container
      });
      document.body.appendChild(container);
      document.addEventListener('keydown', this.handleEscKeyClick, false);

      if (this.props.isOpen) {
        document.body.classList.add((0, _reactStyles.css)(_backdrop2.default.backdropOpen));
      } else {
        document.body.classList.remove((0, _reactStyles.css)(_backdrop2.default.backdropOpen));
      }
    }

    componentDidUpdate() {
      if (this.props.isOpen) {
        document.body.classList.add((0, _reactStyles.css)(_backdrop2.default.backdropOpen));
        this.toggleSiblingsFromScreenReaders(true);
      } else {
        document.body.classList.remove((0, _reactStyles.css)(_backdrop2.default.backdropOpen));
        this.toggleSiblingsFromScreenReaders(false);
      }
    }

    componentWillUnmount() {
      if (this.state.container) {
        document.body.removeChild(this.state.container);
      }

      document.removeEventListener('keydown', this.handleEscKeyClick, false);
      document.body.classList.remove((0, _reactStyles.css)(_backdrop2.default.backdropOpen));
    }

    render() {
      const props = _extends({}, this.props);

      const {
        container
      } = this.state;

      if (!_exenv.canUseDOM || !container) {
        return null;
      }

      return ReactDOM.createPortal(React.createElement(_ModalContent.ModalContent, _extends({}, props, {
        title: this.props.title,
        id: this.id,
        ariaDescribedById: this.props.ariaDescribedById
      })), container);
    }

  }

  exports.Modal = Modal;

  _defineProperty(Modal, "propTypes", {
    children: _propTypes2.default.node.isRequired,
    className: _propTypes2.default.string,
    isOpen: _propTypes2.default.bool,
    header: _propTypes2.default.node,
    title: _propTypes2.default.string.isRequired,
    hideTitle: _propTypes2.default.bool,
    showClose: _propTypes2.default.bool,
    ariaDescribedById: _propTypes2.default.string,
    footer: _propTypes2.default.node,
    actions: _propTypes2.default.any,
    onClose: _propTypes2.default.func,
    width: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string]),
    isLarge: _propTypes2.default.bool,
    isSmall: _propTypes2.default.bool
  });

  _defineProperty(Modal, "currentId", 0);

  _defineProperty(Modal, "defaultProps", {
    className: '',
    isOpen: false,
    hideTitle: false,
    showClose: true,
    ariaDescribedById: '',
    actions: [],
    onClose: () => undefined,
    isLarge: false,
    isSmall: false
  });
});
//# sourceMappingURL=Modal.js.map