(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-icons", "@patternfly/react-styles/css/components/OptionsMenu/options-menu", "@patternfly/react-styles"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-icons"), require("@patternfly/react-styles/css/components/OptionsMenu/options-menu"), require("@patternfly/react-styles"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactIcons, global.optionsMenu, global.reactStyles);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _reactIcons, _optionsMenu, _reactStyles) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.OptionsMenuToggle = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _optionsMenu2 = _interopRequireDefault(_optionsMenu);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  const OptionsMenuToggle = exports.OptionsMenuToggle = ({
    parentId = '',
    onToggle = () => null,
    isOpen = false,
    isPlain = false,
    isHovered = false,
    isActive = false,
    isFocused = false,
    isDisabled = false,
    toggleTemplate = React.createElement(React.Fragment, null),
    hideCaret = false,
    'aria-label': ariaLabel = 'Options menu'
  }) => {
    return React.createElement("button", {
      className: (0, _reactStyles.css)(_optionsMenu2.default.optionsMenuToggle, isPlain && (0, _reactStyles.getModifier)(_optionsMenu2.default, 'plain'), isHovered && (0, _reactStyles.getModifier)(_optionsMenu2.default, 'hover'), isActive && (0, _reactStyles.getModifier)(_optionsMenu2.default, 'active'), isFocused && (0, _reactStyles.getModifier)(_optionsMenu2.default, 'focus'), isDisabled && (0, _reactStyles.getModifier)(_optionsMenu2.default, 'disabled')),
      id: `${parentId}-toggle`,
      "aria-haspopup": "listbox",
      "aria-label": ariaLabel,
      "aria-expanded": isOpen,
      onClick: onToggle
    }, toggleTemplate && (!isPlain ? React.createElement("span", {
      className: (0, _reactStyles.css)(_optionsMenu2.default.optionsMenuToggleText)
    }, toggleTemplate) : React.createElement(React.Fragment, null, toggleTemplate)), !hideCaret && React.createElement(_reactIcons.CaretDownIcon, {
      "aria-hidden": true,
      className: (0, _reactStyles.css)(_optionsMenu2.default.optionsMenuToggleIcon)
    }));
  };

  OptionsMenuToggle.propTypes = {
    parentId: _propTypes2.default.string,
    onToggle: _propTypes2.default.func,
    isOpen: _propTypes2.default.bool,
    isPlain: _propTypes2.default.bool,
    isFocused: _propTypes2.default.bool,
    isHovered: _propTypes2.default.bool,
    isActive: _propTypes2.default.bool,
    isDisabled: _propTypes2.default.bool,
    hideCaret: _propTypes2.default.bool,
    'aria-label': _propTypes2.default.string,
    toggleTemplate: _propTypes2.default.element
  };
});
//# sourceMappingURL=OptionsMenuToggle.js.map