(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles/css/components/OptionsMenu/options-menu", "@patternfly/react-styles/css/components/Pagination/pagination", "@patternfly/react-styles", "../Dropdown", "@patternfly/react-icons", "./OptionsToggle"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles/css/components/OptionsMenu/options-menu"), require("@patternfly/react-styles/css/components/Pagination/pagination"), require("@patternfly/react-styles"), require("../Dropdown"), require("@patternfly/react-icons"), require("./OptionsToggle"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.optionsMenu, global.pagination, global.reactStyles, global.Dropdown, global.reactIcons, global.OptionsToggle);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _optionsMenu, _pagination, _reactStyles, _Dropdown, _reactIcons, _OptionsToggle) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.PaginationOptionsMenu = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _optionsMenu2 = _interopRequireDefault(_optionsMenu);

  var _pagination2 = _interopRequireDefault(_pagination);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  class PaginationOptionsMenu extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty(this, "parentRef", React.createRef());

      _defineProperty(this, "onToggle", isOpen => {
        this.setState({
          isOpen
        });
      });

      _defineProperty(this, "onSelect", () => {
        this.setState(prevState => {
          return {
            isOpen: !prevState.isOpen
          };
        });
      });

      _defineProperty(this, "renderItems", () => {
        const {
          perPageOptions,
          perPage,
          onPerPageSelect,
          perPageSuffix
        } = this.props;
        return perPageOptions.map(({
          value,
          title
        }) => React.createElement(_Dropdown.DropdownItem, {
          key: value,
          component: "button",
          "data-action": `per-page-${value}`,
          className: (0, _reactStyles.css)(_optionsMenu2.default.optionsMenuMenuItem, perPage === value && 'pf-m-selected'),
          onClick: event => onPerPageSelect(event, value)
        }, title, React.createElement("span", {
          className: (0, _reactStyles.css)(_pagination2.default.paginationMenuText)
        }, ` ${perPageSuffix}`), perPage === value && React.createElement("i", {
          className: (0, _reactStyles.css)(_optionsMenu2.default.optionsMenuMenuItemIcon)
        }, React.createElement(_reactIcons.CheckIcon, null))));
      });

      this.state = {
        isOpen: false
      };
    }

    render() {
      const {
        className,
        widgetId,
        isDisabled,
        itemsPerPageTitle,
        dropDirection,
        optionsToggle,
        perPageOptions,
        toggleTemplate,
        firstIndex,
        lastIndex,
        itemCount,
        itemsTitle
      } = this.props;
      const {
        isOpen
      } = this.state;
      return React.createElement("div", {
        className: (0, _reactStyles.css)(_optionsMenu2.default.optionsMenu, className),
        ref: this.parentRef
      }, React.createElement("span", {
        id: `${widgetId}-label`,
        hidden: true
      }, itemsPerPageTitle, ":"), React.createElement(_Dropdown.Dropdown, {
        direction: dropDirection,
        onSelect: this.onSelect,
        isOpen: isOpen,
        toggle: React.createElement(_OptionsToggle.OptionsToggle, {
          optionsToggle: optionsToggle,
          showToggle: perPageOptions && perPageOptions.length > 0,
          onToggle: this.onToggle,
          isOpen: isOpen,
          widgetId: widgetId,
          firstIndex: firstIndex,
          lastIndex: lastIndex,
          itemCount: itemCount,
          itemsTitle: itemsTitle,
          toggleTemplate: toggleTemplate,
          parentRef: this.parentRef.current,
          isDisabled: isDisabled
        }),
        dropdownItems: this.renderItems(),
        isPlain: true
      }));
    }

  }

  exports.PaginationOptionsMenu = PaginationOptionsMenu;

  _defineProperty(PaginationOptionsMenu, "propTypes", {
    className: _propTypes2.default.string,
    widgetId: _propTypes2.default.string,
    isDisabled: _propTypes2.default.bool,
    dropDirection: _propTypes2.default.oneOf(['up', 'down']),
    perPageOptions: _propTypes2.default.arrayOf(_propTypes2.default.any),
    itemsPerPageTitle: _propTypes2.default.string,
    perPageSuffix: _propTypes2.default.string,
    itemsTitle: _propTypes2.default.string,
    optionsToggle: _propTypes2.default.string,
    itemCount: _propTypes2.default.number,
    firstIndex: _propTypes2.default.number,
    lastIndex: _propTypes2.default.number,
    perPage: _propTypes2.default.number,
    toggleTemplate: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.string]),
    onPerPageSelect: _propTypes2.default.func
  });

  _defineProperty(PaginationOptionsMenu, "defaultProps", {
    className: '',
    widgetId: '',
    isDisabled: false,
    dropDirection: _Dropdown.DropdownDirection.down,
    perPageOptions: [],
    itemsPerPageTitle: 'Items per page',
    perPageSuffix: 'per page',
    optionsToggle: 'Select',
    perPage: 0,
    firstIndex: 0,
    lastIndex: 0,
    itemCount: 0,
    itemsTitle: 'items',
    toggleTemplate: ({
      firstIndex,
      lastIndex,
      itemCount,
      itemsTitle
    }) => React.createElement(React.Fragment, null, React.createElement("strong", null, firstIndex, " - ", lastIndex), ' ', "of", React.createElement("strong", null, itemCount), " ", itemsTitle),
    onPerPageSelect: () => null
  });
});
//# sourceMappingURL=PaginationOptionsMenu.js.map