(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles/css/components/Progress/progress", "@patternfly/react-styles"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles/css/components/Progress/progress"), require("@patternfly/react-styles"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.progress, global.reactStyles);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _progress, _reactStyles) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ProgressBar = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _progress2 = _interopRequireDefault(_progress);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  ;

  const ProgressBar = exports.ProgressBar = _ref => {
    let {
      ariaProps,
      className = '',
      children = null,
      value
    } = _ref,
        props = _objectWithoutProperties(_ref, ["ariaProps", "className", "children", "value"]);

    return React.createElement("div", _extends({}, props, {
      className: (0, _reactStyles.css)(_progress2.default.progressBar, className)
    }, ariaProps), React.createElement("div", {
      className: (0, _reactStyles.css)(_progress2.default.progressIndicator),
      style: {
        width: `${value}%`
      }
    }, React.createElement("span", {
      className: (0, _reactStyles.css)(_progress2.default.progressMeasure)
    }, children)));
  };

  ProgressBar.propTypes = {
    children: _propTypes2.default.node,
    className: _propTypes2.default.string,
    value: _propTypes2.default.number.isRequired,
    ariaProps: _propTypes2.default.shape({
      'aria-describedby': _propTypes2.default.string,
      'aria-valuemin': _propTypes2.default.number,
      'aria-valuenow': _propTypes2.default.number,
      'aria-valuemax': _propTypes2.default.number,
      'aria-valuetext': _propTypes2.default.string
    }).isRequired
  };
});
//# sourceMappingURL=ProgressBar.js.map