(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles/css/components/Button/button", "@patternfly/react-styles"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles/css/components/Button/button"), require("@patternfly/react-styles"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.button, global.reactStyles);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _button, _reactStyles) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Button = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _button2 = _interopRequireDefault(_button);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  const Button = exports.Button = _ref => {
    let {
      children = null,
      className = '',
      component = 'button',
      isActive = false,
      isBlock = false,
      isDisabled = false,
      isFocus = false,
      isHover = false,
      isInline = false,
      type = 'button',
      variant = 'primary',
      'aria-label': ariaLabel = null,
      icon = null,
      render = true
    } = _ref,
        props = _objectWithoutProperties(_ref, ["children", "className", "component", "isActive", "isBlock", "isDisabled", "isFocus", "isHover", "isInline", "type", "variant", "aria-label", "icon", "render"]);

    if (!render) {
      return React.createElement("p", null, "no render");
    }

    const Component = component;
    const isButtonElement = Component === 'button';
    return React.createElement(Component, _extends({}, props, {
      "aria-disabled": isButtonElement ? null : isDisabled,
      "aria-label": ariaLabel,
      className: (0, _reactStyles.css)(_button2.default.button, (0, _reactStyles.getModifier)(_button2.default.modifiers, variant), isBlock && _button2.default.modifiers.block, isDisabled && _button2.default.modifiers.disabled, isActive && _button2.default.modifiers.active, isFocus && _button2.default.modifiers.focus, isHover && _button2.default.modifiers.hover, isInline && variant === 'link' && _button2.default.modifiers.inline, className),
      disabled: isButtonElement ? isDisabled : null,
      tabIndex: isDisabled && !isButtonElement ? -1 : null,
      type: isButtonElement ? type : null
    }), icon && variant === 'link' && React.createElement("span", {
      className: "pf-c-button__icon"
    }, icon), children);
  };

  Button.propTypes = {
    render: _propTypes2.default.bool
  };
});
//# sourceMappingURL=Button.js.map