import _pt from "prop-types";

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * header-row.tsx
 *
 * Forked from reactabular-table version 8.14.0
 * https://github.com/reactabular/reactabular/tree/v8.14.0/packages/reactabular-table/src
 */
import * as React from 'react';
import { evaluateFormatters } from './evaluate-formatters';
import { evaluateTransforms } from './evaluate-transforms';
import { mergeProps } from './merge-props';
export const HeaderRow = ({
  rowData,
  rowIndex,
  renderers,
  onRow = () => Object
}) => {
  return React.createElement(renderers.row, onRow(rowData, {
    rowIndex
  }), rowData.map((column, columnIndex) => {
    const {
      property,
      header = {},
      props = {}
    } = column;
    const evaluatedProperty = property || header && header.property;
    const {
      label,
      transforms = [],
      formatters = []
    } = header;
    const extraParameters = {
      columnIndex,
      property: evaluatedProperty,
      column
    };
    const transformedProps = evaluateTransforms(transforms, label, extraParameters);

    if (!transformedProps) {
      // tslint:disable-next-line:no-console
      console.warn('Table.Header - Failed to receive a transformed result'); // eslint-disable-line max-len, no-console
    }

    return React.createElement(renderers.cell, _objectSpread({
      key: `${columnIndex}-header`
    }, mergeProps(props, header && header.props, transformedProps)), transformedProps.children || evaluateFormatters(formatters)(label, extraParameters));
  }));
};
HeaderRow.propTypes = {
  rowData: _pt.any.isRequired,
  rowIndex: _pt.number.isRequired,
  onRow: _pt.any
};
//# sourceMappingURL=header-row.js.map