function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/Table/table';
import { ActionsColumn } from '../../ActionsColumn';

const resolveOrDefault = (resolver, defaultValue, rowData, extraData) => typeof resolver === 'function' ? resolver(rowData, extraData) : defaultValue;

export const cellActions = (actions, actionResolver, areActionsDisabled) => (label, {
  rowData,
  column,
  rowIndex,
  columnIndex,
  column: {
    extraParams: {
      dropdownPosition,
      dropdownDirection
    }
  },
  property
}) => {
  const extraData = {
    rowIndex,
    columnIndex,
    column,
    property
  };
  const resolvedActions = resolveOrDefault(actionResolver, actions, rowData, extraData);
  const resolvedIsDisabled = resolveOrDefault(areActionsDisabled, rowData && rowData.disableActions, rowData, extraData);
  const renderProps = resolvedActions && resolvedActions.length > 0 ? {
    children: React.createElement(ActionsColumn, {
      items: resolvedActions,
      dropdownPosition: dropdownPosition,
      dropdownDirection: dropdownDirection,
      isDisabled: resolvedIsDisabled,
      rowData: rowData,
      extraData: extraData
    }, label)
  } : {};
  return _objectSpread({
    className: css(styles.tableAction),
    isVisible: true
  }, renderProps);
};
//# sourceMappingURL=cellActions.js.map