function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

export { selectable } from './decorators/selectable';
export { sortable } from './decorators/sortable';
export { cellActions } from './decorators/cellActions';
export { cellWidth } from './decorators/cellWidth';
export { wrappable } from './decorators/wrappable';
export { textCenter } from './decorators/textCenter';
export { collapsible, expandedRow, expandable } from './decorators/collapsible';
export { compoundExpand } from './decorators/compoundExpand';
export { headerCol } from './decorators/headerCol';
export { classNames, Visibility } from './decorators/classNames';

const emptyTD = () => ({
  scope: '',
  component: 'td'
});

const scopeColTransformer = () => ({
  scope: 'col'
});

const emptyCol = label => _objectSpread({}, label ? {} : {
  scope: ''
});

const parentId = (_value, {
  rowData
}) => ({
  parentId: rowData.parent
});

const mapProps = (_label, {
  property,
  rowData
}) => _objectSpread({}, rowData[property] && rowData[property].props);

export { emptyTD, scopeColTransformer, emptyCol, parentId, mapProps };
//# sourceMappingURL=transformers.js.map