"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderRow = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _evaluateFormatters = require("./evaluate-formatters");

var _evaluateTransforms = require("./evaluate-transforms");

var _mergeProps = require("./merge-props");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var HeaderRow = function HeaderRow(_ref) {
  var rowData = _ref.rowData,
      rowIndex = _ref.rowIndex,
      renderers = _ref.renderers,
      _ref$onRow = _ref.onRow,
      onRow = _ref$onRow === void 0 ? function () {
    return Object;
  } : _ref$onRow;
  return React.createElement(renderers.row, onRow(rowData, {
    rowIndex: rowIndex
  }), rowData.map(function (column, columnIndex) {
    var property = column.property,
        _column$header = column.header,
        header = _column$header === void 0 ? {} : _column$header,
        _column$props = column.props,
        props = _column$props === void 0 ? {} : _column$props;
    var evaluatedProperty = property || header && header.property;
    var label = header.label,
        _header$transforms = header.transforms,
        transforms = _header$transforms === void 0 ? [] : _header$transforms,
        _header$formatters = header.formatters,
        formatters = _header$formatters === void 0 ? [] : _header$formatters;
    var extraParameters = {
      columnIndex: columnIndex,
      property: evaluatedProperty,
      column: column
    };
    var transformedProps = (0, _evaluateTransforms.evaluateTransforms)(transforms, label, extraParameters);

    if (!transformedProps) {
      // tslint:disable-next-line:no-console
      console.warn('Table.Header - Failed to receive a transformed result'); // eslint-disable-line max-len, no-console
    }

    return React.createElement(renderers.cell, _objectSpread({
      key: "".concat(columnIndex, "-header")
    }, (0, _mergeProps.mergeProps)(props, header && header.props, transformedProps)), transformedProps.children || (0, _evaluateFormatters.evaluateFormatters)(formatters)(label, extraParameters));
  }));
};

exports.HeaderRow = HeaderRow;
HeaderRow.propTypes = {
  rowData: _propTypes["default"].any.isRequired,
  rowIndex: _propTypes["default"].number.isRequired,
  onRow: _propTypes["default"].any
};
//# sourceMappingURL=header-row.js.map